/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.yaml.YamlMapFactoryBean;
import org.springframework.boot.yaml.YamlProcessor;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class YamlMapFactoryBeanTests {
    private final YamlMapFactoryBean factory = new YamlMapFactoryBean();

    @Test
    public void testSetIgnoreResourceNotFound() throws Exception {
        this.factory.setResolutionMethod(YamlProcessor.ResolutionMethod.OVERRIDE_AND_IGNORE);
        this.factory.setResources((Resource[])new FileSystemResource[]{new FileSystemResource("non-exsitent-file.yml")});
        Assert.assertEquals((long)0L, (long)this.factory.getObject().size());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetBarfOnResourceNotFound() throws Exception {
        this.factory.setResources((Resource[])new FileSystemResource[]{new FileSystemResource("non-exsitent-file.yml")});
        Assert.assertEquals((long)0L, (long)this.factory.getObject().size());
    }

    @Test
    public void testGetObject() throws Exception {
        this.factory.setResources((Resource[])new ByteArrayResource[]{new ByteArrayResource("foo: bar".getBytes())});
        Assert.assertEquals((long)1L, (long)this.factory.getObject().size());
    }

    @Test
    public void testOverrideAndremoveDefaults() throws Exception {
        this.factory.setResources((Resource[])new ByteArrayResource[]{new ByteArrayResource("foo:\n  bar: spam".getBytes()), new ByteArrayResource("foo:\n  spam: bar".getBytes())});
        Assert.assertEquals((long)1L, (long)this.factory.getObject().size());
        Assert.assertEquals((long)2L, (long)((Map)this.factory.getObject().get("foo")).size());
    }

    @Test
    public void testFirstFound() throws Exception {
        this.factory.setResolutionMethod(YamlProcessor.ResolutionMethod.FIRST_FOUND);
        this.factory.setResources(new Resource[]{new AbstractResource(){

            public String getDescription() {
                return "non-existent";
            }

            public InputStream getInputStream() throws IOException {
                throw new IOException("planned");
            }
        }, new ByteArrayResource("foo:\n  spam: bar".getBytes())});
        Assert.assertEquals((long)1L, (long)this.factory.getObject().size());
    }

    @Test
    public void testMapWithPeriodsInKey() throws Exception {
        this.factory.setResources((Resource[])new ByteArrayResource[]{new ByteArrayResource("foo:\n  ? key1.key2\n  : value".getBytes())});
        Map map = this.factory.getObject();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("foo"));
        Object object = map.get("foo");
        Assert.assertTrue((boolean)(object instanceof LinkedHashMap));
        Map sub = (Map)object;
        Assert.assertTrue((boolean)sub.containsKey("key1.key2"));
        Assert.assertEquals((Object)"value", sub.get("key1.key2"));
    }
}

