/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public enum DatabaseDriver {
    UNKNOWN(null, null),
    DERBY("Apache Derby", "org.apache.derby.jdbc.EmbeddedDriver", null, "SELECT 1 FROM SYSIBM.SYSDUMMY1"),
    H2("H2", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "SELECT 1"),
    HSQLDB("HSQL Database Engine", "org.hsqldb.jdbc.JDBCDriver", "org.hsqldb.jdbc.pool.JDBCXADataSource", "SELECT COUNT(*) FROM INFORMATION_SCHEMA.SYSTEM_USERS"),
    SQLITE("SQLite", "org.sqlite.JDBC"),
    MYSQL("MySQL", "com.mysql.jdbc.Driver", "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource", "SELECT 1"),
    MARIADB("MySQL", "org.mariadb.jdbc.Driver", "org.mariadb.jdbc.MariaDbDataSource", "SELECT 1"),
    GAE(null, "com.google.appengine.api.rdbms.AppEngineDriver"),
    ORACLE("Oracle", "oracle.jdbc.OracleDriver", "oracle.jdbc.xa.client.OracleXADataSource", "SELECT 'Hello' from DUAL"),
    POSTGRESQL("PostgreSQL", "org.postgresql.Driver", "org.postgresql.xa.PGXADataSource", "SELECT 1"),
    JTDS(null, "net.sourceforge.jtds.jdbc.Driver"),
    SQLSERVER("SQL SERVER", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "SELECT 1"),
    FIREBIRD("Firebird", "org.firebirdsql.jdbc.FBDriver", "org.firebirdsql.pool.FBConnectionPoolDataSource", "SELECT 1 FROM RDB$DATABASE"){

        @Override
        protected boolean matchProductName(String productName) {
            return super.matchProductName(productName) || productName.toLowerCase().startsWith("firebird");
        }
    }
    ,
    DB2("DB2", "com.ibm.db2.jcc.DB2Driver", "com.ibm.db2.jcc.DB2XADataSource", "SELECT 1 FROM SYSIBM.SYSDUMMY1"){

        @Override
        protected boolean matchProductName(String productName) {
            return super.matchProductName(productName) || productName.toLowerCase().startsWith("db2/");
        }
    }
    ,
    DB2_AS400("DB2 UDB for AS/400", "com.ibm.as400.access.AS400JDBCDriver", "com.ibm.as400.access.AS400JDBCXADataSource", "SELECT 1 FROM SYSIBM.SYSDUMMY1"){

        @Override
        protected boolean matchProductName(String productName) {
            return super.matchProductName(productName) || productName.toLowerCase().contains("as/400");
        }
    }
    ,
    TERADATA("Teradata", "com.teradata.jdbc.TeraDriver"),
    INFORMIX("Informix Dynamic Server", "com.informix.jdbc.IfxDriver", null, "select count(*) from systables");

    private final String productName;
    private final String driverClassName;
    private final String xaDataSourceClassName;
    private final String validationQuery;

    private DatabaseDriver(String name, String driverClassName) {
        this(name, driverClassName, null);
    }

    private DatabaseDriver(String name, String driverClassName, String xaDataSourceClassName) {
        this(name, driverClassName, xaDataSourceClassName, null);
    }

    private DatabaseDriver(String productName, String driverClassName, String xaDataSourceClassName, String validationQuery) {
        this.productName = productName;
        this.driverClassName = driverClassName;
        this.xaDataSourceClassName = xaDataSourceClassName;
        this.validationQuery = validationQuery;
    }

    protected boolean matchProductName(String productName) {
        return this.productName != null && this.productName.equalsIgnoreCase(productName);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public static DatabaseDriver fromJdbcUrl(String url) {
        if (StringUtils.hasLength((String)url)) {
            Assert.isTrue((boolean)url.startsWith("jdbc"), (String)"URL must start with 'jdbc'");
            String urlWithoutPrefix = url.substring("jdbc".length()).toLowerCase();
            for (DatabaseDriver driver : DatabaseDriver.values()) {
                String prefix = ":" + driver.name().toLowerCase() + ":";
                if (driver == UNKNOWN || !urlWithoutPrefix.startsWith(prefix)) continue;
                return driver;
            }
        }
        return UNKNOWN;
    }

    public static DatabaseDriver fromProductName(String productName) {
        if (StringUtils.hasLength((String)productName)) {
            for (DatabaseDriver candidate : DatabaseDriver.values()) {
                if (!candidate.matchProductName(productName)) continue;
                return candidate;
            }
        }
        return UNKNOWN;
    }
}

