/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.net.URL;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TomcatEmbeddedWebappClassLoader
extends WebappClassLoader {
    private static final Log logger = LogFactory.getLog(TomcatEmbeddedWebappClassLoader.class);

    public TomcatEmbeddedWebappClassLoader() {
    }

    public TomcatEmbeddedWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findExistingLoadedClass(name);
        Class<?> clazz = result = result == null ? this.doLoadClass(name) : result;
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return this.resolveIfNecessary(result, resolve);
    }

    private Class<?> findExistingLoadedClass(String name) {
        Class resultClass = this.findLoadedClass0(name);
        resultClass = resultClass == null ? this.findLoadedClass(name) : resultClass;
        return resultClass;
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        this.checkPackageAccess(name);
        if (this.delegate || this.filter(name, true)) {
            Class<?> result = this.loadFromParent(name);
            return result == null ? this.findClassIgnoringNotFound(name) : result;
        }
        Class<?> result = this.findClassIgnoringNotFound(name);
        return result == null ? this.loadFromParent(name) : result;
    }

    private Class<?> resolveIfNecessary(Class<?> resultClass, boolean resolve) {
        if (resolve) {
            this.resolveClass(resultClass);
        }
        return resultClass;
    }

    protected void addURL(URL url) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Ignoring request to add " + url + " to the tomcat classloader"));
        }
    }

    private Class<?> loadFromParent(String name) {
        if (this.parent == null) {
            return null;
        }
        try {
            return Class.forName(name, false, this.parent);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private Class<?> findClassIgnoringNotFound(String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private void checkPackageAccess(String name) throws ClassNotFoundException {
        if (this.securityManager != null && name.lastIndexOf(46) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, name.lastIndexOf(46)));
            }
            catch (SecurityException ex) {
                throw new ClassNotFoundException("Security Violation, attempt to use Restricted Class: " + name, ex);
            }
        }
    }
}

