/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloud;

import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public enum CloudPlatform {
    CLOUD_FOUNDRY{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("VCAP_APPLICATION") || environment.containsProperty("VCAP_SERVICES");
        }
    }
    ,
    HEROKU{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("DYNO");
        }
    }
    ,
    SAP{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("HC_LANDSCAPE");
        }
    }
    ,
    KUBERNETES{
        private static final String SERVICE_HOST_SUFFIX = "_SERVICE_HOST";
        private static final String SERVICE_PORT_SUFFIX = "_SERVICE_PORT";

        @Override
        public boolean isActive(Environment environment) {
            if (environment instanceof ConfigurableEnvironment) {
                return this.isActive((ConfigurableEnvironment)environment);
            }
            return false;
        }

        private boolean isActive(ConfigurableEnvironment environment) {
            PropertySource environmentPropertySource = environment.getPropertySources().get("systemEnvironment");
            if (environmentPropertySource instanceof EnumerablePropertySource) {
                return this.isActive((EnumerablePropertySource)environmentPropertySource);
            }
            return false;
        }

        private boolean isActive(EnumerablePropertySource<?> environmentPropertySource) {
            for (String propertyName : environmentPropertySource.getPropertyNames()) {
                String serviceName;
                if (!propertyName.endsWith(SERVICE_HOST_SUFFIX) || environmentPropertySource.getProperty((serviceName = propertyName.substring(0, propertyName.length() - SERVICE_HOST_SUFFIX.length())) + SERVICE_PORT_SUFFIX) == null) continue;
                return true;
            }
            return false;
        }
    };


    public abstract boolean isActive(Environment var1);

    public boolean isUsingForwardHeaders() {
        return true;
    }

    public static CloudPlatform getActive(Environment environment) {
        if (environment != null) {
            for (CloudPlatform cloudPlatform : CloudPlatform.values()) {
                if (!cloudPlatform.isActive(environment)) continue;
                return cloudPlatform;
            }
        }
        return null;
    }
}

