/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.FilteredConfigurationPropertiesSource;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.SpringIterableConfigurationPropertySource;

class FilteredIterableConfigurationPropertiesSource
extends FilteredConfigurationPropertiesSource
implements IterableConfigurationPropertySource {
    private ConfigurationPropertyName[] filteredNames;
    private int numerOfFilteredNames;

    FilteredIterableConfigurationPropertiesSource(IterableConfigurationPropertySource source, Predicate<ConfigurationPropertyName> filter) {
        super(source, filter);
        ConfigurationPropertyName[] filterableNames = this.getFilterableNames(source);
        if (filterableNames != null) {
            this.filteredNames = new ConfigurationPropertyName[filterableNames.length];
            this.numerOfFilteredNames = 0;
            for (ConfigurationPropertyName name : filterableNames) {
                if (!filter.test(name)) continue;
                this.filteredNames[this.numerOfFilteredNames++] = name;
            }
        }
    }

    private ConfigurationPropertyName[] getFilterableNames(IterableConfigurationPropertySource source) {
        SpringIterableConfigurationPropertySource springPropertySource;
        if (source instanceof SpringIterableConfigurationPropertySource && (springPropertySource = (SpringIterableConfigurationPropertySource)source).isImmutablePropertySource()) {
            return springPropertySource.getConfigurationPropertyNames();
        }
        if (source instanceof FilteredIterableConfigurationPropertiesSource) {
            FilteredIterableConfigurationPropertiesSource filteredSource = (FilteredIterableConfigurationPropertiesSource)source;
            return filteredSource.filteredNames;
        }
        return null;
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        if (this.filteredNames != null) {
            return Arrays.stream(this.filteredNames, 0, this.numerOfFilteredNames);
        }
        return this.getSource().stream().filter(this.getFilter());
    }

    @Override
    protected IterableConfigurationPropertySource getSource() {
        return (IterableConfigurationPropertySource)super.getSource();
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        if (this.filteredNames != null) {
            return ConfigurationPropertyState.search(this.filteredNames, 0, this.numerOfFilteredNames, name::isAncestorOf);
        }
        return ConfigurationPropertyState.search(this, name::isAncestorOf);
    }
}

