/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.util.ClassUtils;

class ConfigurationPropertiesBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    ConfigurationPropertiesBeanFactoryInitializationAotProcessor() {
    }

    public @Nullable ConfigurationPropertiesReflectionHintsContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames = beanFactory.getBeanNamesForAnnotation(ConfigurationProperties.class);
        ArrayList bindables = new ArrayList();
        for (String beanName : beanNames) {
            Class beanType = beanFactory.getType(beanName, false);
            if (beanType == null) continue;
            BindMethod bindMethod = beanFactory.containsBeanDefinition(beanName) ? (BindMethod)((Object)beanFactory.getBeanDefinition(beanName).getAttribute(BindMethod.class.getName())) : null;
            bindables.add(Bindable.of(ClassUtils.getUserClass((Class)beanType)).withBindMethod(bindMethod != null ? bindMethod : BindMethod.JAVA_BEAN));
        }
        return !bindables.isEmpty() ? new ConfigurationPropertiesReflectionHintsContribution(bindables) : null;
    }

    static final class ConfigurationPropertiesReflectionHintsContribution
    implements BeanFactoryInitializationAotContribution {
        private final List<Bindable<?>> bindables;

        private ConfigurationPropertiesReflectionHintsContribution(List<Bindable<?>> bindables) {
            this.bindables = bindables;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            BindableRuntimeHintsRegistrar.forBindables(this.bindables).registerHints(generationContext.getRuntimeHints());
        }

        Iterable<Bindable<?>> getBindables() {
            return this.bindables;
        }
    }
}

