/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.common.file;

import java.util.Map;
import org.springframework.cloud.fn.common.file.FileConsumerProperties;
import org.springframework.integration.core.GenericTransformer;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.file.splitter.FileSplitter;
import org.springframework.integration.file.transformer.FileToByteArrayTransformer;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.transformer.StreamTransformer;

public final class FileUtils {
    private FileUtils() {
    }

    public static IntegrationFlowBuilder enhanceFlowForReadingMode(IntegrationFlowBuilder flowBuilder, FileConsumerProperties fileConsumerProperties) {
        switch (fileConsumerProperties.getMode()) {
            case contents: {
                ((IntegrationFlowBuilder)flowBuilder.enrichHeaders(Map.of("contentType", "application/octet-stream"))).transform((GenericTransformer)new FileToByteArrayTransformer());
                break;
            }
            case lines: {
                Boolean withMarkers = fileConsumerProperties.getWithMarkers();
                if (withMarkers == null) {
                    withMarkers = false;
                }
                ((IntegrationFlowBuilder)flowBuilder.enrichHeaders(Map.of("contentType", "text/plain"))).split((AbstractMessageSplitter)new FileSplitter(true, withMarkers.booleanValue(), fileConsumerProperties.getMarkersJson()));
                break;
            }
            case ref: {
                flowBuilder.enrichHeaders(Map.of("contentType", "application/json"));
                break;
            }
            default: {
                throw new IllegalArgumentException(fileConsumerProperties.getMode().name() + " is not a supported file reading mode.");
            }
        }
        return flowBuilder;
    }

    public static IntegrationFlowBuilder enhanceStreamFlowForReadingMode(IntegrationFlowBuilder flowBuilder, FileConsumerProperties fileConsumerProperties) {
        switch (fileConsumerProperties.getMode()) {
            case contents: {
                ((IntegrationFlowBuilder)flowBuilder.enrichHeaders(Map.of("contentType", "application/octet-stream"))).transform((GenericTransformer)new StreamTransformer());
                break;
            }
            case lines: {
                Boolean withMarkers = fileConsumerProperties.getWithMarkers();
                if (withMarkers == null) {
                    withMarkers = false;
                }
                ((IntegrationFlowBuilder)flowBuilder.enrichHeaders(Map.of("contentType", "text/plain"))).split((AbstractMessageSplitter)new FileSplitter(true, withMarkers.booleanValue(), fileConsumerProperties.getMarkersJson()));
                break;
            }
            default: {
                throw new IllegalArgumentException(fileConsumerProperties.getMode().name() + " is not a supported file reading mode when streaming.");
            }
        }
        return flowBuilder;
    }
}

