/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.common.file.remote;

import org.springframework.expression.Expression;
import org.springframework.integration.aop.MessageSourceMutator;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class RemoteFileRenamingAdvice
implements MessageSourceMutator {
    private final RemoteFileTemplate<?> template;
    private final String remoteFileSeparator;
    private final Expression newName;

    public RemoteFileRenamingAdvice(RemoteFileTemplate<?> template, String remoteFileSeparator, Expression newNameExp) {
        this.template = template;
        this.remoteFileSeparator = remoteFileSeparator;
        this.newName = newNameExp;
    }

    @Nullable
    public Message<?> afterReceive(@Nullable Message<?> result, MessageSource<?> source) {
        if (result != null) {
            String remoteDir = (String)result.getHeaders().get((Object)"file_remoteDirectory");
            String remoteFile = (String)result.getHeaders().get((Object)"file_remoteFile");
            String newNameValue = (String)this.newName.getValue(result, String.class);
            if (newNameValue != null && !newNameValue.isEmpty()) {
                this.template.rename(remoteDir + this.remoteFileSeparator + remoteFile, newNameValue);
            }
        }
        return result;
    }
}

