/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.endpoint;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.NacosPropertySourceRepository;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.cloud.alibaba.nacos.refresh.NacosRefreshHistory;

@Endpoint(id="nacos-config")
public class NacosConfigEndpoint {
    private final NacosConfigProperties properties;
    private final NacosRefreshHistory refreshHistory;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public NacosConfigEndpoint(NacosConfigProperties properties, NacosRefreshHistory refreshHistory) {
        this.properties = properties;
        this.refreshHistory = refreshHistory;
    }

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("NacosConfigProperties", this.properties);
        List<NacosPropertySource> all = NacosPropertySourceRepository.getAll();
        ArrayList sources = new ArrayList();
        for (NacosPropertySource ps : all) {
            HashMap<String, String> source = new HashMap<String, String>(16);
            source.put("dataId", ps.getDataId());
            source.put("lastSynced", this.dateFormat.format(ps.getTimestamp()));
            sources.add(source);
        }
        result.put("Sources", sources);
        result.put("RefreshHistory", this.refreshHistory.getRecords());
        return result;
    }
}

