/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.config;

import org.springframework.cloud.alibaba.sentinel.datasource.config.AbstractDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.NacosDataSourceFactoryBean;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.NacosDataSourceWithAuthorizationFactoryBean;
import org.springframework.util.StringUtils;

public class NacosDataSourceProperties
extends AbstractDataSourceProperties {
    private String serverAddr;
    private String groupId;
    private String dataId;
    private String endpoint;
    private String namespace;
    private String accessKey;
    private String secretKey;

    public NacosDataSourceProperties() {
        super(NacosDataSourceFactoryBean.class.getName());
    }

    @Override
    public void preCheck() {
        if (!StringUtils.isEmpty((Object)System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.endpoint"))) {
            this.setServerAddr(null);
            this.setFactoryBeanName(NacosDataSourceWithAuthorizationFactoryBean.class.getName());
            this.setEndpoint(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.endpoint"));
            this.setNamespace(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.namespace"));
            this.setAccessKey(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.access-key"));
            this.setSecretKey(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.secret-key"));
        }
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public static NacosDataSourceProperties buildFlowByEDAS() {
        return NacosDataSourceProperties.buildByEDAS("flow");
    }

    public static NacosDataSourceProperties buildDegradeByEDAS() {
        return NacosDataSourceProperties.buildByEDAS("degrade");
    }

    public static NacosDataSourceProperties buildByEDAS(String type) {
        NacosDataSourceProperties result = new NacosDataSourceProperties();
        result.setFactoryBeanName(NacosDataSourceWithAuthorizationFactoryBean.class.getName());
        result.setEndpoint(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.endpoint"));
        result.setNamespace(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.namespace"));
        result.setAccessKey(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.access-key"));
        result.setSecretKey(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.secret-key"));
        result.setDataType("json");
        result.setDataId(System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.project-name") + "-" + type);
        result.setGroupId("nacos-sentinel");
        return result;
    }
}

