/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.config.annotation;

import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.context.config.xml.GlobalBeanDefinitionUtils;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientConfigurationUtils;
import org.springframework.cloud.aws.jdbc.config.annotation.EnableRdsInstance;
import org.springframework.cloud.aws.jdbc.config.annotation.RdsInstanceConfigurer;
import org.springframework.cloud.aws.jdbc.datasource.TomcatJdbcDataSourceFactory;
import org.springframework.cloud.aws.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import org.springframework.cloud.aws.jdbc.rds.AmazonRdsReadReplicaAwareDataSourceFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextDefaultConfigurationRegistrar.class})
public class AmazonRdsInstanceConfiguration {
    @Bean
    public static RdsInstanceConfigurerBeanPostProcessor rdsInstanceConfigurerBeanPostProcessor() {
        return new RdsInstanceConfigurerBeanPostProcessor();
    }

    public static class Registrar
    extends AbstractRegistrar {
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableRdsInstance.class.getName(), false));
            Assert.notNull((Object)annotationAttributes, (String)("@EnableRdsInstance is not present on importing class " + importingClassMetadata.getClassName()));
            String amazonRdsClientBeanName = AmazonWebserviceClientConfigurationUtils.registerAmazonWebserviceClient((Object)this, (BeanDefinitionRegistry)registry, (String)"com.amazonaws.services.rds.AmazonRDSClient", null, null).getBeanName();
            this.registerDataSource(registry, amazonRdsClientBeanName, annotationAttributes.getString("dbInstanceIdentifier"), annotationAttributes.getString("password"), annotationAttributes.getBoolean("readReplicaSupport"), annotationAttributes.getString("username"), annotationAttributes.getString("databaseName"));
        }
    }

    public static abstract class AbstractRegistrar
    implements ImportBeanDefinitionRegistrar {
        protected void registerDataSource(BeanDefinitionRegistry beanDefinitionRegistry, String amazonRdsClientBeanName, String dbInstanceIdentifier, String password, boolean readReplica, String userName, String databaseName) {
            BeanDefinitionBuilder datasourceBuilder = this.getBeanDefinitionBuilderForDataSource(readReplica);
            datasourceBuilder.addConstructorArgReference(amazonRdsClientBeanName);
            datasourceBuilder.addConstructorArgValue((Object)dbInstanceIdentifier);
            datasourceBuilder.addConstructorArgValue((Object)password);
            datasourceBuilder.addPropertyValue("username", (Object)userName);
            datasourceBuilder.addPropertyValue("databaseName", (Object)databaseName);
            String resourceResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)beanDefinitionRegistry);
            datasourceBuilder.addPropertyReference("resourceIdResolver", resourceResolverBeanName);
            datasourceBuilder.addPropertyValue("dataSourceFactory", (Object)BeanDefinitionBuilder.rootBeanDefinition(TomcatJdbcDataSourceFactory.class).getBeanDefinition());
            beanDefinitionRegistry.registerBeanDefinition(dbInstanceIdentifier, (BeanDefinition)datasourceBuilder.getBeanDefinition());
        }

        private BeanDefinitionBuilder getBeanDefinitionBuilderForDataSource(boolean readReplicaEnabled) {
            BeanDefinitionBuilder datasourceBuilder = readReplicaEnabled ? BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsReadReplicaAwareDataSourceFactoryBean.class) : BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsDataSourceFactoryBean.class);
            return datasourceBuilder;
        }
    }

    public static class RdsInstanceConfigurerBeanPostProcessor
    implements BeanPostProcessor,
    BeanFactoryAware {
        private RdsInstanceConfigurer rdsInstanceConfigurer;

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof AmazonRdsDataSourceFactoryBean && this.rdsInstanceConfigurer != null) {
                ((AmazonRdsDataSourceFactoryBean)((Object)bean)).setDataSourceFactory(this.rdsInstanceConfigurer.getDataSourceFactory());
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ListableBeanFactory) {
                Collection configurer = ((ListableBeanFactory)beanFactory).getBeansOfType(RdsInstanceConfigurer.class).values();
                if (configurer.isEmpty()) {
                    return;
                }
                if (configurer.size() > 1) {
                    throw new IllegalStateException("Only one RdsInstanceConfigurer may exist");
                }
                this.rdsInstanceConfigurer = (RdsInstanceConfigurer)configurer.iterator().next();
            }
        }
    }
}

