/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.aws.messaging.core.QueueMessageUtils;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public class QueueMessageChannel
extends AbstractMessageChannel
implements PollableChannel {
    static final String ATTRIBUTE_NAMES = "All";
    public static final String MESSAGE_ATTRIBUTE_NAMES = "All";
    private final AmazonSQS amazonSqs;
    private final String queueUrl;

    public QueueMessageChannel(AmazonSQS amazonSqs, String queueUrl) {
        this.amazonSqs = amazonSqs;
        this.queueUrl = queueUrl;
    }

    protected boolean sendInternal(org.springframework.messaging.Message<?> message, long timeout) {
        try {
            SendMessageRequest sendMessageRequest = new SendMessageRequest(this.queueUrl, String.valueOf(message.getPayload())).withDelaySeconds(Integer.valueOf(QueueMessageChannel.getDelaySeconds(timeout)));
            Map<String, MessageAttributeValue> messageAttributes = this.getMessageAttributes(message);
            if (!messageAttributes.isEmpty()) {
                sendMessageRequest.withMessageAttributes(messageAttributes);
            }
            this.amazonSqs.sendMessage(sendMessageRequest);
        }
        catch (AmazonServiceException e) {
            throw new MessageDeliveryException(message, e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private Map<String, MessageAttributeValue> getMessageAttributes(org.springframework.messaging.Message<?> message) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        for (Map.Entry messageHeader : message.getHeaders().entrySet()) {
            String messageHeaderName = (String)messageHeader.getKey();
            Object messageHeaderValue = messageHeader.getValue();
            if ("contentType".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getContentTypeMessageAttribute(messageHeaderValue));
                continue;
            }
            if ("id".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute(messageHeaderValue.toString()));
                continue;
            }
            if (messageHeaderValue instanceof String) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute((String)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof Number) {
                messageAttributes.put(messageHeaderName, this.getNumberMessageAttribute(messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof ByteBuffer) {
                messageAttributes.put(messageHeaderName, this.getBinaryMessageAttribute((ByteBuffer)messageHeaderValue));
                continue;
            }
            this.logger.warn((Object)String.format("Message header with name '%s' and type '%s' cannot be sent as message attribute because it is not supported by SQS.", messageHeaderName, messageHeaderValue != null ? messageHeaderValue.getClass().getName() : ""));
        }
        return messageAttributes;
    }

    private MessageAttributeValue getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return new MessageAttributeValue().withDataType("Binary").withBinaryValue(messageHeaderValue);
    }

    private MessageAttributeValue getContentTypeMessageAttribute(Object messageHeaderValue) {
        if (messageHeaderValue instanceof MimeType) {
            return new MessageAttributeValue().withDataType("String").withStringValue(messageHeaderValue.toString());
        }
        if (messageHeaderValue instanceof String) {
            return new MessageAttributeValue().withDataType("String").withStringValue((String)messageHeaderValue);
        }
        return null;
    }

    private MessageAttributeValue getStringMessageAttribute(String messageHeaderValue) {
        return new MessageAttributeValue().withDataType("String").withStringValue(messageHeaderValue);
    }

    private MessageAttributeValue getNumberMessageAttribute(Object messageHeaderValue) {
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValue.getClass()), (String)"Only standard number types are accepted as message header.");
        return new MessageAttributeValue().withDataType("Number." + messageHeaderValue.getClass().getName()).withStringValue(messageHeaderValue.toString());
    }

    public org.springframework.messaging.Message<String> receive() {
        return this.receive(0L);
    }

    public org.springframework.messaging.Message<String> receive(long timeout) {
        ReceiveMessageResult receiveMessageResult = this.amazonSqs.receiveMessage(new ReceiveMessageRequest(this.queueUrl).withMaxNumberOfMessages(Integer.valueOf(1)).withWaitTimeSeconds(Integer.valueOf(Long.valueOf(timeout).intValue())).withAttributeNames(new String[]{"All"}).withMessageAttributeNames(new String[]{"All"}));
        if (receiveMessageResult.getMessages().isEmpty()) {
            return null;
        }
        Message amazonMessage = (Message)receiveMessageResult.getMessages().get(0);
        org.springframework.messaging.Message<String> message = QueueMessageUtils.createMessage(amazonMessage);
        this.amazonSqs.deleteMessage(new DeleteMessageRequest(this.queueUrl, amazonMessage.getReceiptHandle()));
        return message;
    }

    private static int getDelaySeconds(long timeout) {
        return Math.max(Long.valueOf(timeout).intValue(), 0);
    }
}

