/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.QueueMessagingTemplate;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.aws.messaging.listener.SendToHandlerMethodReturnValueHandler;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.CollectionUtils;

public class QueueMessageHandlerFactory {
    private List<HandlerMethodArgumentResolver> argumentResolvers;
    private List<HandlerMethodReturnValueHandler> returnValueHandlers;
    private DestinationResolvingMessageSendingOperations<?> sendToMessagingTemplate;
    private AmazonSQSAsync amazonSqs;
    private ResourceIdResolver resourceIdResolver;
    private BeanFactory beanFactory;
    private List<MessageConverter> messageConverters;

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        this.returnValueHandlers = returnValueHandlers;
    }

    public void setSendToMessagingTemplate(DestinationResolvingMessageSendingOperations<?> sendToMessagingTemplate) {
        this.sendToMessagingTemplate = sendToMessagingTemplate;
    }

    public AmazonSQS getAmazonSqs() {
        return this.amazonSqs;
    }

    public void setAmazonSqs(AmazonSQSAsync amazonSqs) {
        this.amazonSqs = amazonSqs;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public QueueMessageHandler createQueueMessageHandler() {
        QueueMessageHandler queueMessageHandler = new QueueMessageHandler(CollectionUtils.isEmpty(this.messageConverters) ? Arrays.asList(this.getDefaultMappingJackson2MessageConverter()) : this.messageConverters);
        if (!CollectionUtils.isEmpty(this.argumentResolvers)) {
            queueMessageHandler.getCustomArgumentResolvers().addAll(this.argumentResolvers);
        }
        if (!CollectionUtils.isEmpty(this.returnValueHandlers)) {
            queueMessageHandler.getCustomReturnValueHandlers().addAll(this.returnValueHandlers);
        }
        SendToHandlerMethodReturnValueHandler sendToHandlerMethodReturnValueHandler = this.sendToMessagingTemplate != null ? new SendToHandlerMethodReturnValueHandler(this.sendToMessagingTemplate) : new SendToHandlerMethodReturnValueHandler(this.getDefaultSendToQueueMessagingTemplate(this.amazonSqs, this.resourceIdResolver));
        sendToHandlerMethodReturnValueHandler.setBeanFactory(this.beanFactory);
        queueMessageHandler.getCustomReturnValueHandlers().add(sendToHandlerMethodReturnValueHandler);
        return queueMessageHandler;
    }

    private QueueMessagingTemplate getDefaultSendToQueueMessagingTemplate(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver) {
        return new QueueMessagingTemplate(amazonSqs, resourceIdResolver, (MessageConverter)this.getDefaultMappingJackson2MessageConverter());
    }

    public List<MessageConverter> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMessageConverters(List<MessageConverter> messageConverters) {
        this.messageConverters = messageConverters;
    }

    private MappingJackson2MessageConverter getDefaultMappingJackson2MessageConverter() {
        MappingJackson2MessageConverter jacksonMessageConverter = new MappingJackson2MessageConverter();
        jacksonMessageConverter.setSerializedPayloadClass(String.class);
        jacksonMessageConverter.setStrictContentTypeMatch(true);
        return jacksonMessageConverter;
    }
}

