/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

final class MapMapper {
    private final Map<String, String> source;
    private final Map<String, Object> destination;

    MapMapper(Map<String, String> source, Map<String, Object> destination) {
        this.source = source;
        this.destination = destination;
    }

    Source from(String ... keys) {
        return new SourceImpl(keys);
    }

    static final class NoopSource
    implements Source {
        NoopSource() {
        }

        @Override
        public void to(String key) {
        }

        @Override
        public void toIfAbsent(String key) {
        }

        @Override
        public void to(String key, Function<String, Object> function) {
        }

        @Override
        public void to(String key, TriFunction<String, String, String, Object> function) {
        }

        @Override
        public Source when(Predicate<Object> predicate) {
            return this;
        }
    }

    final class SourceImpl
    implements Source {
        private final String[] keys;

        private SourceImpl(String[] keys) {
            this.keys = keys;
        }

        @Override
        public void to(String key) {
            this.to(key, (String v) -> v);
        }

        @Override
        public void toIfAbsent(String key) {
            if (MapMapper.this.destination.containsKey(key)) {
                return;
            }
            this.to(key, (String v) -> v);
        }

        @Override
        public void to(String key, Function<String, Object> function) {
            if (this.keys.length != 1) {
                throw new IllegalStateException(String.format("source size %d cannot be transformed as one argument", this.keys.length));
            }
            if (!Arrays.stream(this.keys).allMatch(MapMapper.this.source::containsKey)) {
                return;
            }
            MapMapper.this.destination.put(key, function.apply((String)MapMapper.this.source.get(this.keys[0])));
        }

        @Override
        public void to(String key, TriFunction<String, String, String, Object> function) {
            if (this.keys.length != 3) {
                throw new IllegalStateException(String.format("source size %d cannot be consumed as three arguments", this.keys.length));
            }
            if (!Arrays.stream(this.keys).allMatch(MapMapper.this.source::containsKey)) {
                return;
            }
            MapMapper.this.destination.put(key, function.apply((String)MapMapper.this.source.get(this.keys[0]), (String)MapMapper.this.source.get(this.keys[1]), (String)MapMapper.this.source.get(this.keys[2])));
        }

        @Override
        public Source when(Predicate<Object> predicate) {
            if (this.keys.length != 1) {
                throw new IllegalStateException(String.format("source size %d cannot be transformed as one argument", this.keys.length));
            }
            if (predicate.test(MapMapper.this.source.get(this.keys[0]))) {
                return this;
            }
            return new NoopSource();
        }
    }

    static interface Source {
        public void to(String var1);

        public void toIfAbsent(String var1);

        public void to(String var1, Function<String, Object> var2);

        public void to(String var1, TriFunction<String, String, String, Object> var2);

        public Source when(Predicate<Object> var1);
    }

    static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

