/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.cloud.bindings.Binding;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class PostgreSqlBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "postgresql";
    public static final String SSL_MODE = "sslmode";
    public static final String SSL_ROOT_CERT = "sslrootcert";
    public static final String OPTIONS = "options";
    public static final String SPRING_DATASOURCE_URL = "spring.datasource.url";
    public static final String SPRING_R2DBC_URL = "spring.r2dbc.url";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            String dbOptions;
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("password").to("spring.datasource.password");
            map.from("host", "port", "database").to(SPRING_DATASOURCE_URL, (host, port, database) -> String.format("jdbc:postgresql://%s:%s/%s", host, port, database));
            String sslParam = this.buildSslModeParam((Binding)binding);
            String sslModeOptions = dbOptions = this.buildDbOptions((Binding)binding);
            if (!"".equals(sslParam) && !"".equals(sslModeOptions)) {
                sslModeOptions = sslParam + "&" + sslModeOptions;
            } else if (!"".equals(sslParam)) {
                sslModeOptions = sslParam;
            }
            if (!"".equals(sslModeOptions)) {
                properties.put(SPRING_DATASOURCE_URL, properties.get(SPRING_DATASOURCE_URL) + "?" + sslModeOptions);
            }
            map.from("username").to("spring.datasource.username");
            map.from("jdbc-url").to(SPRING_DATASOURCE_URL);
            properties.put("spring.datasource.driver-class-name", "org.postgresql.Driver");
            map.from("password").to("spring.r2dbc.password");
            map.from("host", "port", "database").to(SPRING_R2DBC_URL, (host, port, database) -> String.format("r2dbc:postgresql://%s:%s/%s", host, port, database));
            if (!"".equals(sslModeOptions)) {
                properties.put(SPRING_R2DBC_URL, properties.get(SPRING_R2DBC_URL) + "?" + sslModeOptions);
            }
            map.from("username").to("spring.r2dbc.username");
            map.from("r2dbc-url").to(SPRING_R2DBC_URL);
        });
    }

    private String buildDbOptions(Binding binding) {
        String options = binding.getSecret().getOrDefault(OPTIONS, "");
        String crdbOption = "";
        ArrayList<String> dbOptions = new ArrayList<String>();
        if (!options.equals("")) {
            String[] allOpts;
            for (String o : allOpts = options.split("&")) {
                String[] keyval = o.split("=");
                if (keyval.length != 2 || keyval[0].length() == 0 || keyval[1].length() == 0) continue;
                if (keyval[0].equals("--cluster")) {
                    crdbOption = keyval[0] + "=" + keyval[1];
                    continue;
                }
                dbOptions.add("-c " + keyval[0] + "=" + keyval[1]);
            }
        }
        String combinedOptions = crdbOption;
        if (dbOptions.size() > 0) {
            String otherOpts = String.join((CharSequence)" ", dbOptions);
            combinedOptions = !combinedOptions.equals("") ? combinedOptions + " " + otherOpts : otherOpts;
        }
        if (!"".equals(combinedOptions)) {
            combinedOptions = "options=" + combinedOptions;
        }
        return combinedOptions;
    }

    private String buildSslModeParam(Binding binding) {
        String sslmode = binding.getSecret().getOrDefault(SSL_MODE, "");
        String sslRootCert = binding.getSecret().getOrDefault(SSL_ROOT_CERT, "");
        StringBuilder sslparam = new StringBuilder();
        if (!"".equals(sslmode)) {
            sslparam.append(SSL_MODE).append("=").append(sslmode);
        }
        if (!"".equals(sslRootCert)) {
            if (!"".equals(sslmode)) {
                sslparam.append("&");
            }
            sslparam.append(SSL_ROOT_CERT).append("=").append(binding.getPath()).append(FileSystems.getDefault().getSeparator()).append(sslRootCert);
        }
        return sslparam.toString();
    }
}

