/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class CassandraBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "cassandra";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("cluster-name").to("spring.data.cassandra.cluster-name");
            map.from("compression").to("spring.data.cassandra.compression");
            map.from("contact-points").to("spring.data.cassandra.contact-points");
            map.from("keyspace-name").to("spring.data.cassandra.keyspace-name");
            map.from("password").to("spring.data.cassandra.password");
            map.from("port").to("spring.data.cassandra.port");
            map.from("ssl").to("spring.data.cassandra.ssl");
            map.from("username").to("spring.data.cassandra.username");
        });
    }
}

