/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.endpoint;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.bus.endpoint.AbstractBusEndpoint;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.EnvironmentChangeRemoteApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;

@Endpoint(id="busenv")
public class EnvironmentBusEndpoint
extends AbstractBusEndpoint {
    public EnvironmentBusEndpoint(ApplicationEventPublisher publisher, String id, Destination.Factory destinationFactory) {
        super(publisher, id, destinationFactory);
    }

    @WriteOperation
    public void busEnvWithDestination(String name, String value, @Selector(match=Selector.Match.ALL_REMAINING) String[] destinations) {
        Map<String, String> params = Collections.singletonMap(name, value);
        String destination = StringUtils.arrayToDelimitedString((Object[])destinations, (String)":");
        this.publish(new EnvironmentChangeRemoteApplicationEvent((Object)this, this.getInstanceId(), this.getDestination(destination), params));
    }

    @WriteOperation
    public void busEnv(String name, String value) {
        Map<String, String> params = Collections.singletonMap(name, value);
        this.publish(new EnvironmentChangeRemoteApplicationEvent((Object)this, this.getInstanceId(), this.getDestination(null), params));
    }
}

