/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadConfigurationBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;

public class Resilience4jBulkheadProvider {
    private final ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry;
    private final BulkheadRegistry bulkheadRegistry;
    private final ConcurrentHashMap<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> configurations = new ConcurrentHashMap();
    private Function<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> defaultConfiguration = id -> new Resilience4jBulkheadConfigurationBuilder().bulkheadConfig(BulkheadConfig.ofDefaults()).threadPoolBulkheadConfig(ThreadPoolBulkheadConfig.ofDefaults()).build();

    public Resilience4jBulkheadProvider(ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, BulkheadRegistry bulkheadRegistry) {
        this.bulkheadRegistry = bulkheadRegistry;
        this.threadPoolBulkheadRegistry = threadPoolBulkheadRegistry;
    }

    public void configureDefault(Function<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configure(Consumer<Resilience4jBulkheadConfigurationBuilder> consumer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder builder = new Resilience4jBulkheadConfigurationBuilder();
            consumer.accept(builder);
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = builder.build();
            this.configurations.put(id, configuration);
        }
    }

    public void addBulkheadCustomizer(Customizer<Bulkhead> customizer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
            Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig());
            customizer.customize((Object)bulkhead);
        }
    }

    public void addThreadPoolBulkheadCustomizer(Customizer<ThreadPoolBulkhead> customizer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
            ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkheadRegistry.bulkhead(id, configuration.getThreadPoolBulkheadConfig());
            customizer.customize((Object)threadPoolBulkhead);
        }
    }

    protected BulkheadRegistry getBulkheadRegistry() {
        return this.bulkheadRegistry;
    }

    protected ThreadPoolBulkheadRegistry getThreadPoolBulkheadRegistry() {
        return this.threadPoolBulkheadRegistry;
    }

    public <T> T run(String id, Supplier<T> toRun, Function<Throwable, T> fallback, CircuitBreaker circuitBreaker, TimeLimiter timeLimiter) {
        Supplier<CompletionStage<T>> bulkheadCall = this.decorateBulkhead(id, toRun);
        Supplier timeLimiterCall = timeLimiter.decorateCompletionStage(Executors.newSingleThreadScheduledExecutor(), bulkheadCall);
        Supplier circuitBreakerCall = circuitBreaker.decorateCompletionStage(timeLimiterCall);
        try {
            return ((CompletionStage)circuitBreakerCall.get()).toCompletableFuture().get();
        }
        catch (Exception e) {
            System.out.println("exception " + e.getMessage());
            return fallback.apply(e);
        }
    }

    private <T> Supplier<CompletionStage<T>> decorateBulkhead(String id, Supplier<T> supplier) {
        Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
        if (this.bulkheadRegistry.find(id).isPresent() && !this.threadPoolBulkheadRegistry.find(id).isPresent()) {
            Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig());
            CompletableFuture asyncCall = CompletableFuture.supplyAsync(supplier);
            return Bulkhead.decorateCompletionStage((Bulkhead)bulkhead, () -> asyncCall);
        }
        ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkheadRegistry.bulkhead(id, configuration.getThreadPoolBulkheadConfig());
        return threadPoolBulkhead.decorateSupplier(supplier);
    }
}

