/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadProvider;
import org.springframework.cloud.client.circuitbreaker.Customizer;

public class Resilience4JCircuitBreaker
implements org.springframework.cloud.client.circuitbreaker.CircuitBreaker {
    static final String CIRCUIT_BREAKER_GROUP_TAG = "group";
    private final String id;
    private final String groupName;
    private Resilience4jBulkheadProvider bulkheadProvider;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerRegistry registry;
    private final TimeLimiterRegistry timeLimiterRegistry;
    private final TimeLimiterConfig timeLimiterConfig;
    private final ExecutorService executorService;
    private final Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer;

    public Resilience4JCircuitBreaker(String id, String groupName, CircuitBreakerConfig circuitBreakerConfig, TimeLimiterConfig timeLimiterConfig, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, ExecutorService executorService, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer, Resilience4jBulkheadProvider bulkheadProvider) {
        this.id = id;
        this.groupName = groupName;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.registry = circuitBreakerRegistry;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.timeLimiterConfig = timeLimiterConfig;
        this.executorService = executorService;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
        this.bulkheadProvider = bulkheadProvider;
    }

    public Resilience4JCircuitBreaker(String id, String groupName, CircuitBreakerConfig circuitBreakerConfig, TimeLimiterConfig timeLimiterConfig, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer, Resilience4jBulkheadProvider bulkheadProvider) {
        this(id, groupName, circuitBreakerConfig, timeLimiterConfig, circuitBreakerRegistry, timeLimiterRegistry, null, circuitBreakerCustomizer, bulkheadProvider);
    }

    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        Map<String, String> tags = Map.of(CIRCUIT_BREAKER_GROUP_TAG, this.groupName);
        TimeLimiter timeLimiter = this.timeLimiterRegistry.find(this.id).orElseGet(() -> this.timeLimiterRegistry.find(this.groupName).orElseGet(() -> this.timeLimiterRegistry.timeLimiter(this.id, this.timeLimiterConfig, tags)));
        CircuitBreaker defaultCircuitBreaker = this.registry.circuitBreaker(this.id, this.circuitBreakerConfig, tags);
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        if (this.bulkheadProvider != null) {
            return this.bulkheadProvider.run(this.groupName, toRun, fallback, defaultCircuitBreaker, timeLimiter, tags);
        }
        if (this.executorService != null) {
            Supplier<Future> futureSupplier = () -> this.executorService.submit(((Supplier)toRun)::get);
            Callable restrictedCall = TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, futureSupplier);
            Callable callable = CircuitBreaker.decorateCallable((CircuitBreaker)defaultCircuitBreaker, (Callable)restrictedCall);
            try {
                return (T)callable.call();
            }
            catch (Throwable t) {
                return fallback.apply(t);
            }
        }
        Supplier decorator = CircuitBreaker.decorateSupplier((CircuitBreaker)defaultCircuitBreaker, toRun);
        try {
            return decorator.get();
        }
        catch (Throwable t) {
            return fallback.apply(t);
        }
    }
}

