/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.reactor.bulkhead.operator.BulkheadOperator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadConfigurationBuilder;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveResilience4jBulkheadProvider {
    private final BulkheadRegistry bulkheadRegistry;
    private final ConcurrentHashMap<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> configurations = new ConcurrentHashMap();
    private Function<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> defaultConfiguration;

    public ReactiveResilience4jBulkheadProvider(BulkheadRegistry bulkheadRegistry) {
        this.bulkheadRegistry = bulkheadRegistry;
        this.defaultConfiguration = id -> new Resilience4jBulkheadConfigurationBuilder().bulkheadConfig((BulkheadConfig)this.bulkheadRegistry.getDefaultConfig()).build();
    }

    public void configureDefault(@NonNull Function<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> defaultConfiguration) {
        Assert.notNull(defaultConfiguration, (String)"Default configuration must not be null");
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configure(Consumer<Resilience4jBulkheadConfigurationBuilder> consumer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder builder = new Resilience4jBulkheadConfigurationBuilder();
            consumer.accept(builder);
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = builder.build();
            this.configurations.put(id, configuration);
        }
    }

    public void addBulkheadCustomizer(Consumer<Bulkhead> customizer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
            Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig());
            customizer.accept(bulkhead);
        }
    }

    public BulkheadRegistry getBulkheadRegistry() {
        return this.bulkheadRegistry;
    }

    public <T> Mono<T> decorateMono(String id, Map<String, String> tags, Mono<T> mono) {
        Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this::getConfiguration);
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig(), tags);
        return mono.transformDeferred((Function)BulkheadOperator.of((Bulkhead)bulkhead));
    }

    public <T> Flux<T> decorateFlux(String id, Map<String, String> tags, Flux<T> flux) {
        Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this::getConfiguration);
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig(), tags);
        return flux.transformDeferred((Function)BulkheadOperator.of((Bulkhead)bulkhead));
    }

    private Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration getConfiguration(String id) {
        Resilience4jBulkheadConfigurationBuilder builder = new Resilience4jBulkheadConfigurationBuilder();
        Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration defaultConfiguration = this.defaultConfiguration.apply(id);
        Optional bulkheadConfiguration = this.bulkheadRegistry.getConfiguration(id);
        builder.bulkheadConfig(bulkheadConfiguration.orElse(defaultConfiguration.getBulkheadConfig()));
        return builder.build();
    }
}

