/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.cloud.common.security.support.LdapSecurityProperties;
import org.springframework.cloud.common.security.support.LdapSecurityPropertiesValid;
import org.springframework.util.StringUtils;

public class LdapSecurityPropertiesValidator
implements ConstraintValidator<LdapSecurityPropertiesValid, Object> {
    public void initialize(LdapSecurityPropertiesValid constraintAnnotation) {
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (!(value instanceof LdapSecurityProperties)) {
            throw new IllegalArgumentException("@LdapSecurityPropertiesValid only applies to LdapSecurityProperties");
        }
        LdapSecurityProperties ldapSecurityProperties = (LdapSecurityProperties)value;
        if (!ldapSecurityProperties.isEnabled()) {
            return true;
        }
        boolean isValid = true;
        if (!(StringUtils.isEmpty((Object)ldapSecurityProperties.getUserDnPattern()) ^ StringUtils.isEmpty((Object)ldapSecurityProperties.getUserSearchFilter()))) {
            context.buildConstraintViolationWithTemplate("Exactly one of 'userDnPattern' or 'userSearch' must be provided").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

