/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.FixedAuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.FixedPrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class TokenValidatingUserInfoTokenServices
extends DefaultTokenServices {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TokenStore tokenStore;
    private ClientDetailsService clientDetailsService;
    private final String userInfoEndpointUrl;
    private final String tokenInfoUri;
    private final String clientId;
    private final String clientSecret;
    private OAuth2RestOperations restTemplate;
    private String tokenName = "token";
    private AuthoritiesExtractor authoritiesExtractor = new FixedAuthoritiesExtractor();
    private PrincipalExtractor principalExtractor = new FixedPrincipalExtractor();
    private RestOperations remoteTokenRestTemplate;
    private AccessTokenConverter tokenConverter = new DefaultAccessTokenConverter();

    public TokenValidatingUserInfoTokenServices(String userInfoEndpointUrl, String tokenInfoUri, String clientId, String clientSecret) {
        Assert.hasText((String)userInfoEndpointUrl, (String)"The userInfoEndpointUrl must be set.");
        Assert.hasText((String)tokenInfoUri, (String)"The tokenInfoUri must be set.");
        Assert.hasText((String)clientId, (String)"The clientId must be set.");
        Assert.hasText((String)clientSecret, (String)"The clientSecret must be set.");
        this.userInfoEndpointUrl = userInfoEndpointUrl;
        this.tokenInfoUri = tokenInfoUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
        RestTemplate localRestTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setPrettyPrint(false);
        messageConverter.setObjectMapper(objectMapper);
        localRestTemplate.getMessageConverters().removeIf(m -> m.getClass().getName().equals(MappingJackson2HttpMessageConverter.class.getName()));
        localRestTemplate.getMessageConverters().add(messageConverter);
        localRestTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getRawStatusCode() != 400) {
                    super.handleError(response);
                }
            }
        });
        this.remoteTokenRestTemplate = localRestTemplate;
    }

    public void setRestTemplate(OAuth2RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setAuthoritiesExtractor(AuthoritiesExtractor authoritiesExtractor) {
        Assert.notNull((Object)authoritiesExtractor, (String)"AuthoritiesExtractor must not be null");
        this.authoritiesExtractor = authoritiesExtractor;
    }

    public void setPrincipalExtractor(PrincipalExtractor principalExtractor) {
        Assert.notNull((Object)principalExtractor, (String)"PrincipalExtractor must not be null");
        this.principalExtractor = principalExtractor;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException, InvalidTokenException {
        OAuth2Authentication authenticationToreturn;
        boolean needToreload = false;
        OAuth2AccessToken accessToken = this.tokenStore.readAccessToken(accessTokenValue);
        if (accessToken == null) {
            needToreload = true;
        } else if (accessToken.isExpired()) {
            this.tokenStore.removeAccessToken(accessToken);
            throw new InvalidTokenException("Access token expired: " + accessTokenValue);
        }
        if (needToreload) {
            OAuth2Authentication authentication;
            authenticationToreturn = authentication = this.retrieveOAuth2AuthenticationFromOAuthServer(accessTokenValue);
        } else {
            OAuth2Authentication authenticationFromTokenStore = this.tokenStore.readAuthentication(accessToken);
            if (authenticationFromTokenStore == null) {
                throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
            }
            if (this.clientDetailsService != null) {
                String clientId = authenticationFromTokenStore.getOAuth2Request().getClientId();
                try {
                    this.clientDetailsService.loadClientByClientId(clientId);
                }
                catch (ClientRegistrationException e) {
                    throw new InvalidTokenException("Client not valid: " + clientId, (Throwable)e);
                }
            }
            authenticationToreturn = authenticationFromTokenStore;
        }
        return authenticationToreturn;
    }

    private OAuth2Authentication retrieveOAuth2AuthenticationFromOAuthServer(String accessTokenValue) {
        OAuth2AccessToken remoteOAuth2AccessToken = this.retrieveAccessTokenFromOAuthServer(accessTokenValue);
        this.restTemplate.getOAuth2ClientContext().setAccessToken(remoteOAuth2AccessToken);
        Map<String, Object> map = this.getUserInfoMap(this.userInfoEndpointUrl);
        if (map.containsKey("error")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("userinfo returned error: " + map.get("error")));
            }
            throw new InvalidTokenException(accessTokenValue);
        }
        OAuth2Authentication authentication = this.extractAuthentication(map);
        this.tokenStore.storeAccessToken(remoteOAuth2AccessToken, authentication);
        return authentication;
    }

    private OAuth2Authentication extractAuthentication(Map<String, Object> map) {
        Object principal = this.getPrincipal(map);
        List authorities = this.authoritiesExtractor.extractAuthorities(map);
        OAuth2Request request = new OAuth2Request(null, this.clientId, null, true, null, null, null, null, null);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(principal, (Object)"N/A", (Collection)authorities);
        token.setDetails(map);
        return new OAuth2Authentication(request, (Authentication)token);
    }

    protected Object getPrincipal(Map<String, Object> map) {
        Object principal = this.principalExtractor.extractPrincipal(map);
        return principal == null ? "unknown" : principal;
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }

    private Map<String, Object> getUserInfoMap(String userInfoEndpointUrl) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting user info from: " + userInfoEndpointUrl));
        }
        try {
            return (Map)this.restTemplate.getForEntity(userInfoEndpointUrl, Map.class, new Object[0]).getBody();
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Could not fetch user details: " + ex.getClass() + ", " + ex.getMessage()));
            return Collections.singletonMap("error", "Could not fetch user details");
        }
    }

    protected OAuth2AccessToken retrieveAccessTokenFromOAuthServer(String accessToken) {
        Assert.hasText((String)accessToken, (String)"accessToken must not be null or empty.");
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)this.tokenName, (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.getAuthorizationHeader(this.clientId, this.clientSecret));
        Map<String, Object> map = this.postForMap(this.tokenInfoUri, (MultiValueMap<String, String>)formData, headers);
        if (map.containsKey("error")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("userinfo returned error: " + map.get("error")));
            }
            throw new InvalidTokenException(accessToken);
        }
        return this.tokenConverter.extractAccessToken(accessToken, map);
    }

    protected String getAuthorizationHeader(String clientId, String clientSecret) {
        if (clientId == null || clientSecret == null) {
            this.logger.warn((Object)"Null Client ID or Client Secret detected. Endpoint that requires authentication will reject request with 401 error.");
        }
        String creds = String.format("%s:%s", clientId, clientSecret);
        try {
            return "Basic " + new String(Base64.getEncoder().encode(creds.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not convert String");
        }
    }

    protected Map<String, Object> postForMap(String path, MultiValueMap<String, String> formData, HttpHeaders headers) {
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        Map result = (Map)this.remoteTokenRestTemplate.exchange(path, HttpMethod.POST, new HttpEntity(formData, (MultiValueMap)headers), Map.class, new Object[0]).getBody();
        return result;
    }

    public void setTokenStore(TokenStore tokenStore) {
        Assert.notNull((Object)tokenStore, (String)"tokenStore cannot be null.");
        super.setTokenStore(tokenStore);
        this.tokenStore = tokenStore;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        Assert.notNull((Object)clientDetailsService, (String)"clientDetailsService cannot be null.");
        super.setClientDetailsService(clientDetailsService);
        this.clientDetailsService = clientDetailsService;
    }

    public void setTokenName(String tokenName) {
        Assert.hasText((String)tokenName, (String)"tokenName cannot be null nor empty.");
        this.tokenName = tokenName;
    }
}

