/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.core.Ordered;

public class DiscoveryClientHealthIndicator
implements DiscoveryHealthIndicator,
Ordered {
    private static final Log log = LogFactory.getLog(DiscoveryClientHealthIndicator.class);
    private int order = Integer.MIN_VALUE;
    private DiscoveryClient discoveryClient;

    public DiscoveryClientHealthIndicator(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            List<String> services = this.discoveryClient.getServices();
            builder.status(new Status("UP", this.discoveryClient.description())).withDetail("services", services);
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            builder.down(e);
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "discoveryClient";
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

