/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.springframework.cloud.ClassPathExclusions;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class FilteredClassPathRunner
extends BlockJUnit4ClassRunner {
    public FilteredClassPathRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected TestClass createTestClass(Class<?> testClass) {
        try {
            URLClassLoader classLoader = this.createTestClassLoader(testClass);
            return new FilteredTestClass(classLoader, testClass.getName());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private URLClassLoader createTestClassLoader(Class<?> testClass) throws Exception {
        URLClassLoader classLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        return new FilteredClassLoader(this.filterUrls(this.extractUrls(classLoader), testClass), classLoader.getParent(), (ClassLoader)classLoader);
    }

    private URL[] extractUrls(URLClassLoader classLoader) throws Exception {
        ArrayList<URL> extractedUrls = new ArrayList<URL>();
        for (URL url : classLoader.getURLs()) {
            if (this.isSurefireBooterJar(url)) {
                extractedUrls.addAll(this.extractUrlsFromManifestClassPath(url));
                continue;
            }
            extractedUrls.add(url);
        }
        return extractedUrls.toArray(new URL[extractedUrls.size()]);
    }

    private boolean isSurefireBooterJar(URL url) {
        return url.getPath().contains("surefirebooter");
    }

    private List<URL> extractUrlsFromManifestClassPath(URL booterJar) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String entry : this.getClassPath(booterJar)) {
            urls.add(new URL(entry));
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getClassPath(URL booterJar) throws Exception {
        try (JarFile jarFile = new JarFile(new File(booterJar.toURI()));){
            String[] stringArray = StringUtils.delimitedListToStringArray((String)jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH), (String)" ");
            return stringArray;
        }
    }

    private URL[] filterUrls(URL[] urls, Class<?> testClass) throws Exception {
        ClassPathEntryFilter filter = new ClassPathEntryFilter(testClass);
        ArrayList<URL> filteredUrls = new ArrayList<URL>();
        for (URL url : urls) {
            if (filter.isExcluded(url)) continue;
            filteredUrls.add(url);
        }
        return filteredUrls.toArray(new URL[filteredUrls.size()]);
    }

    private static final class FilteredClassLoader
    extends URLClassLoader {
        private final ClassLoader junitLoader;

        FilteredClassLoader(URL[] urls, ClassLoader parent, ClassLoader junitLoader) {
            super(urls, parent);
            this.junitLoader = junitLoader;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith("org.junit")) {
                return this.junitLoader.loadClass(name);
            }
            return super.loadClass(name);
        }
    }

    private static final class FilteredFrameworkMethod
    extends FrameworkMethod {
        private final ClassLoader classLoader;

        private FilteredFrameworkMethod(ClassLoader classLoader, Method method) {
            super(method);
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                Object object = super.invokeExplosively(target, params);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private static final class FilteredTestClass
    extends TestClass {
        private final ClassLoader classLoader;

        FilteredTestClass(ClassLoader classLoader, String testClassName) throws ClassNotFoundException {
            super(classLoader.loadClass(testClassName));
            this.classLoader = classLoader;
        }

        public List<FrameworkMethod> getAnnotatedMethods(Class<? extends Annotation> annotationClass) {
            try {
                return this.getAnnotatedMethods(annotationClass.getName());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        private List<FrameworkMethod> getAnnotatedMethods(String annotationClassName) throws ClassNotFoundException {
            Class<?> annotationClass = this.classLoader.loadClass(annotationClassName);
            List methods = super.getAnnotatedMethods(annotationClass);
            return this.wrapFrameworkMethods(methods);
        }

        private List<FrameworkMethod> wrapFrameworkMethods(List<FrameworkMethod> methods) {
            ArrayList<FrameworkMethod> wrapped = new ArrayList<FrameworkMethod>(methods.size());
            for (FrameworkMethod frameworkMethod : methods) {
                wrapped.add(new FilteredFrameworkMethod(this.classLoader, frameworkMethod.getMethod()));
            }
            return wrapped;
        }
    }

    private static final class ClassPathEntryFilter {
        private final List<String> exclusions;
        private final AntPathMatcher matcher = new AntPathMatcher();

        private ClassPathEntryFilter(Class<?> testClass) throws Exception {
            ClassPathExclusions exclusions = (ClassPathExclusions)AnnotationUtils.findAnnotation(testClass, ClassPathExclusions.class);
            this.exclusions = exclusions == null ? Collections.emptyList() : Arrays.asList(exclusions.value());
        }

        private boolean isExcluded(URL url) throws Exception {
            if (!"file".equals(url.getProtocol())) {
                return false;
            }
            String name = new File(url.toURI()).getName();
            for (String exclusion : this.exclusions) {
                if (!this.matcher.match(exclusion, name)) continue;
                return true;
            }
            return false;
        }
    }
}

