/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.actuator;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.FeaturesEndpoint;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.actuator.NamedFeature;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class FeaturesEndpointTests {
    private AnnotationConfigApplicationContext context;

    @Before
    public void setup() {
        this.context = new AnnotationConfigApplicationContext();
        this.context.register(new Class[]{JacksonAutoConfiguration.class, FeaturesConfig.class, Config.class});
        this.context.refresh();
    }

    @After
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void invokeWorks() {
        FeaturesEndpoint.Features features = ((FeaturesEndpoint)this.context.getBean(FeaturesEndpoint.class)).invoke();
        Assertions.assertThat((Object)features).isNotNull();
        ((ListAssert)Assertions.assertThat((List)features.getEnabled()).hasSize(2)).contains((Object[])new FeaturesEndpoint.Feature[]{this.newFeature("foo", Foo.class), this.newFeature("Baz Feature", Baz.class)});
        ((ListAssert)Assertions.assertThat((List)features.getDisabled()).hasSize(1)).contains((Object[])new String[]{"Bar"});
    }

    private FeaturesEndpoint.Feature newFeature(String name, Class<?> type) {
        return new FeaturesEndpoint.Feature(name, type.getCanonicalName(), null, null);
    }

    public static class Baz {
    }

    public static class Bar {
    }

    public static class Foo {
    }

    @Configuration
    @EnableConfigurationProperties
    public static class Config {
        @Autowired(required=false)
        private List<HasFeatures> hasFeatures = new ArrayList<HasFeatures>();

        @Bean
        public FeaturesEndpoint cloudEndpoint() {
            return new FeaturesEndpoint(this.hasFeatures);
        }
    }

    @Configuration
    public static class FeaturesConfig {
        @Bean
        Foo foo() {
            return new Foo();
        }

        @Bean
        HasFeatures localFeatures() {
            HasFeatures features = HasFeatures.namedFeatures((NamedFeature[])new NamedFeature[]{new NamedFeature("foo", Foo.class), new NamedFeature("Baz Feature", Baz.class)});
            features.getAbstractFeatures().add(Bar.class);
            return features;
        }
    }
}

