/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class}, properties={"management.port=0"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class AbstractDiscoveryLifecycleTests {
    @Autowired
    private TestDiscoveryLifecycle lifecycle;
    @Value(value="${local.server.port}")
    private int port;
    @Value(value="${local.management.port}")
    private int managementPort;

    @Test
    public void portsWork() {
        Assert.assertNotEquals((String)"Lifecycle port is zero", (long)0L, (long)this.lifecycle.getPort().get());
        Assert.assertNotEquals((String)"Lifecycle port is management port", (long)this.managementPort, (long)this.lifecycle.getPort().get());
        Assert.assertEquals((String)"Lifecycle port is wrong", (long)this.port, (long)this.lifecycle.getPort().get());
        Assert.assertTrue((String)"Lifecycle not running", (boolean)this.lifecycle.isRunning());
        Assert.assertTrue((String)"Lifecycle not registered", (boolean)this.lifecycle.isRegistered());
        Assert.assertEquals((String)"Lifecycle appName is wrong", (Object)"application", (Object)this.lifecycle.getAppName());
    }

    public static class TestDiscoveryLifecycle
    extends AbstractDiscoveryLifecycle {
        private int port = 0;
        private boolean registered = false;
        private boolean deregistered = false;

        protected int getConfiguredPort() {
            return this.port;
        }

        protected void setConfiguredPort(int port) {
            this.port = port;
        }

        protected Object getConfiguration() {
            return this;
        }

        protected void register() {
            this.registered = true;
        }

        protected void deregister() {
            this.deregistered = true;
        }

        protected boolean isEnabled() {
            return true;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public boolean isDeregistered() {
            return this.deregistered;
        }
    }

    @EnableAutoConfiguration
    @Configuration
    public static class Config {
        @Bean
        public TestDiscoveryLifecycle testDiscoveryLifecycle() {
            return new TestDiscoveryLifecycle();
        }
    }
}

