/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.hypermedia.DiscoveredResource;
import org.springframework.cloud.client.hypermedia.ServiceInstanceProvider;
import org.springframework.cloud.client.hypermedia.TraversalDefinition;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.client.Traverson;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@RunWith(value=MockitoJUnitRunner.class)
public class DiscoveredResourceUnitTests {
    @Mock
    ServiceInstanceProvider provider;
    @Mock
    TraversalDefinition traversal;
    @Mock
    Traverson.TraversalBuilder builder;
    @Mock
    RestOperations operations;
    DiscoveredResource resource;

    @Before
    public void setUp() {
        Mockito.when((Object)this.traversal.buildTraversal((Traverson)Matchers.any(Traverson.class))).thenReturn((Object)this.builder);
        this.resource = new DiscoveredResource(this.provider, this.traversal);
        this.resource.setRestOperations(this.operations);
    }

    @Test
    public void isUndiscoveredByDefault() {
        Assert.assertThat((Object)this.resource.getLink(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void verificationTriggersDiscovery() {
        Link link = new Link("target", "rel");
        Mockito.when((Object)this.provider.getServiceInstance()).thenReturn((Object)new DefaultServiceInstance("service", "localhost", 8080, false));
        Mockito.when((Object)this.builder.asTemplatedLink()).thenReturn((Object)link);
        this.resource.verifyOrDiscover();
        Assert.assertThat((Object)this.resource.getLink(), (Matcher)CoreMatchers.is((Object)link));
        ((ServiceInstanceProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.times((int)1))).getServiceInstance();
        ((TraversalDefinition)Mockito.verify((Object)this.traversal, (VerificationMode)Mockito.times((int)1))).buildTraversal((Traverson)Matchers.any(Traverson.class));
    }

    @Test
    public void triggersVerificationOnSubsequentCall() {
        this.verificationTriggersDiscovery();
        this.resource.verifyOrDiscover();
        Assert.assertThat((Object)this.resource.getLink(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ((RestOperations)Mockito.verify((Object)this.operations, (VerificationMode)Mockito.times((int)1))).headForHeaders(Mockito.anyString(), new Object[0]);
    }

    @Test
    public void resetsLinkOnFailedVerification() {
        this.verificationTriggersDiscovery();
        ((RestOperations)Mockito.doThrow(RestClientException.class).when((Object)this.operations)).headForHeaders(Mockito.anyString(), new Object[0]);
        this.resource.verifyOrDiscover();
        Assert.assertThat((Object)this.resource.getLink(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void failedDiscoveryTraversalCausesLinkToStayNull() {
        ((ServiceInstanceProvider)Mockito.doThrow(RuntimeException.class).when((Object)this.provider)).getServiceInstance();
        this.resource.verifyOrDiscover();
        Assert.assertThat((Object)this.resource.getLink(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

