/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.hypermedia.DynamicServiceInstanceProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class DynamicServiceInstanceProviderUnitTests {
    @Mock
    DiscoveryClient client;

    @Test
    public void returnsNoServiceInCaseNoneIsAvailable() {
        Assert.assertThat((Object)new DynamicServiceInstanceProvider(this.client, "service").getServiceInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void returnsFirstServiceInCaseMultipleOnesAreAvailable() {
        ServiceInstance first = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        ServiceInstance second = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.getInstances(Mockito.anyString())).thenReturn(Arrays.asList(first, second));
        Assert.assertThat((Object)new DynamicServiceInstanceProvider(this.client, "service").getServiceInstance(), (Matcher)CoreMatchers.is((Object)first));
    }
}

