/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RetryContext;

@RunWith(value=MockitoJUnitRunner.class)
public class LoadBalancedRetryContextTest {
    private RetryContext context;
    private HttpRequest request;

    @Before
    public void setUp() throws Exception {
        this.context = (RetryContext)Mockito.mock(RetryContext.class);
        this.request = (HttpRequest)Mockito.mock(HttpRequest.class);
    }

    @After
    public void tearDown() throws Exception {
        this.context = null;
        this.request = null;
    }

    @Test
    public void getRequest() throws Exception {
        LoadBalancedRetryContext lbContext = new LoadBalancedRetryContext(this.context, this.request);
        MatcherAssert.assertThat((Object)lbContext.getRequest(), (Matcher)Matchers.is((Object)this.request));
    }

    @Test
    public void setRequest() throws Exception {
        LoadBalancedRetryContext lbContext = new LoadBalancedRetryContext(this.context, this.request);
        HttpRequest newRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        lbContext.setRequest(newRequest);
        MatcherAssert.assertThat((Object)lbContext.getRequest(), (Matcher)Matchers.is((Object)newRequest));
    }

    @Test
    public void getServiceInstance() throws Exception {
        LoadBalancedRetryContext lbContext = new LoadBalancedRetryContext(this.context, this.request);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        lbContext.setServiceInstance(serviceInstance);
        MatcherAssert.assertThat((Object)lbContext.getServiceInstance(), (Matcher)Matchers.is((Object)serviceInstance));
    }
}

