/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.cloud.client.loadbalancer.ServiceRequestWrapper;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;

@RunWith(value=MockitoJUnitRunner.class)
public class LoadBalancerRequestFactoryConfigurationTests {
    @Mock
    private HttpRequest request;
    @Mock
    private HttpRequest transformedRequest;
    @Mock
    private HttpRequest transformedRequest2;
    @Mock
    private ClientHttpRequestExecution execution;
    @Mock
    private ServiceInstance instance;
    private byte[] body = new byte[0];
    private ArgumentCaptor<HttpRequest> httpRequestCaptor;
    private LoadBalancerRequestFactory lbReqFactory;
    private LoadBalancerRequest<?> lbRequest;

    @Before
    public void setup() {
        this.httpRequestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
    }

    protected ConfigurableApplicationContext init(Class<?> config) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Object[0]).web(false).properties(new String[]{"spring.aop.proxyTargetClass=true"}).sources(new Class[]{config, LoadBalancerAutoConfiguration.class}).run(new String[0]);
        this.lbReqFactory = (LoadBalancerRequestFactory)context.getBean(LoadBalancerRequestFactory.class);
        this.lbRequest = this.lbReqFactory.createRequest(this.request, this.body, this.execution);
        return context;
    }

    @Test
    public void transformer() throws Exception {
        ConfigurableApplicationContext context = this.init(Transformer.class);
        LoadBalancerRequestTransformer transformer = (LoadBalancerRequestTransformer)context.getBean("transformer", LoadBalancerRequestTransformer.class);
        Mockito.when((Object)transformer.transformRequest((HttpRequest)Matchers.any(ServiceRequestWrapper.class), (ServiceInstance)Matchers.eq((Object)this.instance))).thenReturn((Object)this.transformedRequest);
        this.lbRequest.apply(this.instance);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"transformer should have transformed the ServiceRequestWrapper into transformedRequest", (Object)this.transformedRequest, (Object)this.httpRequestCaptor.getValue());
    }

    @Test
    public void noTransformer() throws Exception {
        this.init(NoTransformer.class);
        this.lbRequest.apply(this.instance);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"ServiceRequestWrapper should be executed", ServiceRequestWrapper.class, ((HttpRequest)this.httpRequestCaptor.getValue()).getClass());
    }

    @Test
    public void transformersAreOrdered() throws Exception {
        ConfigurableApplicationContext context = this.init(TransformersAreOrdered.class);
        LoadBalancerRequestTransformer transformer = (LoadBalancerRequestTransformer)context.getBean("transformer", LoadBalancerRequestTransformer.class);
        Mockito.when((Object)transformer.transformRequest((HttpRequest)Matchers.any(ServiceRequestWrapper.class), (ServiceInstance)Matchers.eq((Object)this.instance))).thenReturn((Object)this.transformedRequest);
        LoadBalancerRequestTransformer transformer2 = (LoadBalancerRequestTransformer)context.getBean("transformer2", LoadBalancerRequestTransformer.class);
        Mockito.when((Object)transformer2.transformRequest(this.transformedRequest, this.instance)).thenReturn((Object)this.transformedRequest2);
        this.lbRequest.apply(this.instance);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"transformer2 should run after transformer", (Object)this.transformedRequest2, (Object)this.httpRequestCaptor.getValue());
    }

    @Configuration
    static class NoTransformer {
        NoTransformer() {
        }

        @Bean
        public LoadBalancerClient loadBalancerClient() {
            return (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        }
    }

    @Configuration
    static class TransformersAreOrdered {
        TransformersAreOrdered() {
        }

        @Bean
        public LoadBalancerClient loadBalancerClient() {
            return (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        }

        @Bean
        public LoadBalancerRequestTransformer transformer() {
            return (LoadBalancerRequestTransformer)Mockito.mock(LoadBalancerRequestTransformer.class);
        }

        @Bean
        @Order(value=1)
        public LoadBalancerRequestTransformer transformer2() {
            return (LoadBalancerRequestTransformer)Mockito.mock(LoadBalancerRequestTransformer.class);
        }
    }

    @Configuration
    static class Transformer {
        Transformer() {
        }

        @Bean
        public LoadBalancerClient loadBalancerClient() {
            return (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        }

        @Bean
        public LoadBalancerRequestTransformer transformer() {
            return (LoadBalancerRequestTransformer)Mockito.mock(LoadBalancerRequestTransformer.class);
        }
    }
}

