/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.cloud.client.loadbalancer.ServiceRequestWrapper;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;

@RunWith(value=MockitoJUnitRunner.class)
public class LoadBalancerRequestFactoryTests {
    @Mock
    private LoadBalancerClient loadBalancer;
    @Mock
    private HttpRequest request;
    @Mock
    private HttpRequest transformedRequest1;
    @Mock
    private HttpRequest transformedRequest2;
    private byte[] body = new byte[0];
    @Mock
    private ClientHttpRequestExecution execution;
    @Mock
    private ServiceInstance instance;
    @Mock
    private LoadBalancerRequestTransformer transformer1;
    @Mock
    private LoadBalancerRequestTransformer transformer2;
    private ArgumentCaptor<HttpRequest> httpRequestCaptor;

    @Before
    public void setup() {
        this.httpRequestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
    }

    @Test
    public void testNullTransformers() throws Exception {
        this.executeLbRequest(null);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"request should be of type ServiceRequestWrapper", ServiceRequestWrapper.class, ((HttpRequest)this.httpRequestCaptor.getValue()).getClass());
    }

    @Test
    public void testEmptyTransformers() throws Exception {
        List<LoadBalancerRequestTransformer> transformers = Collections.emptyList();
        this.executeLbRequest(transformers);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"request should be of type ServiceRequestWrapper", ServiceRequestWrapper.class, ((HttpRequest)this.httpRequestCaptor.getValue()).getClass());
    }

    @Test
    public void testOneTransformer() throws Exception {
        List<LoadBalancerRequestTransformer> transformers = Arrays.asList(this.transformer1);
        Mockito.when((Object)this.transformer1.transformRequest((HttpRequest)Mockito.any(ServiceRequestWrapper.class), (ServiceInstance)Matchers.eq((Object)this.instance))).thenReturn((Object)this.transformedRequest1);
        this.executeLbRequest(transformers);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"transformer1 should have transformed request into transformedRequest1", (Object)this.transformedRequest1, (Object)this.httpRequestCaptor.getValue());
    }

    @Test
    public void testTwoTransformers() throws Exception {
        List<LoadBalancerRequestTransformer> transformers = Arrays.asList(this.transformer1, this.transformer2);
        Mockito.when((Object)this.transformer1.transformRequest((HttpRequest)Mockito.any(ServiceRequestWrapper.class), (ServiceInstance)Matchers.eq((Object)this.instance))).thenReturn((Object)this.transformedRequest1);
        Mockito.when((Object)this.transformer2.transformRequest(this.transformedRequest1, this.instance)).thenReturn((Object)this.transformedRequest2);
        this.executeLbRequest(transformers);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])Matchers.eq((Object)this.body));
        Assert.assertEquals((String)"transformer2 should have transformed transformedRequest1 into transformedRequest2", (Object)this.transformedRequest2, (Object)this.httpRequestCaptor.getValue());
    }

    private void executeLbRequest(List<LoadBalancerRequestTransformer> transformers) throws Exception {
        LoadBalancerRequestFactory lbReqFactory = new LoadBalancerRequestFactory(this.loadBalancer, transformers);
        LoadBalancerRequest lbRequest = lbReqFactory.createRequest(this.request, this.body, this.execution);
        lbRequest.apply(this.instance);
    }
}

