/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.test.util.EnvironmentTestUtils;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

public class AutoServiceRegistrationAutoConfigurationTests {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void hasAutoServiceRegistration() {
        try (AnnotationConfigApplicationContext context = this.setup(HasAutoServiceRegistrationConfiguration.class);){
            AutoServiceRegistration autoServiceRegistration = (AutoServiceRegistration)context.getBean(AutoServiceRegistration.class);
            Assertions.assertThat((Object)autoServiceRegistration).isNotNull();
        }
    }

    @Test
    public void noAutoServiceRegistrationAndFailFast() {
        this.exception.expect(BeanCreationException.class);
        this.exception.expectMessage(Matchers.containsString((String)"no AutoServiceRegistration"));
        try (AnnotationConfigApplicationContext context = this.setup("spring.cloud.service-registry.auto-registration.failFast=true", new Class[0]);){
            this.assertNoBean(context);
        }
    }

    @Test
    public void noAutoServiceRegistrationAndFailFastFalse() {
        try (AnnotationConfigApplicationContext context = this.setup(new Class[0]);){
            this.assertNoBean(context);
        }
    }

    private void assertNoBean(AnnotationConfigApplicationContext context) {
        Map beans = context.getBeansOfType(AutoServiceRegistration.class);
        Assertions.assertThat((Map)beans).isEmpty();
    }

    private AnnotationConfigApplicationContext setup(Class ... classes) {
        return this.setup((String)null, classes);
    }

    private AnnotationConfigApplicationContext setup(String property, Class ... classes) {
        ArrayList<Class> list = new ArrayList<Class>();
        list.add(AutoServiceRegistrationConfiguration.class);
        list.add(AutoServiceRegistrationAutoConfiguration.class);
        list.addAll(Arrays.asList(classes));
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.register(list.toArray(new Class[0]));
        if (StringUtils.hasText((String)property)) {
            EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)context, (String[])new String[]{property});
        }
        context.refresh();
        return context;
    }

    @Configuration
    static class HasAutoServiceRegistrationConfiguration {
        HasAutoServiceRegistrationConfiguration() {
        }

        @Bean
        public AutoServiceRegistration autoServiceRegistration() {
            return new AutoServiceRegistration(){};
        }
    }
}

