/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultApacheHttpClientConnectionManagerFactoryTests {
    @Test
    public void newConnectionManager() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6);
        Assert.assertEquals((long)6L, (long)((PoolingHttpClientConnectionManager)connectionManager).getDefaultMaxPerRoute());
        Assert.assertEquals((long)2L, (long)((PoolingHttpClientConnectionManager)connectionManager).getMaxTotal());
        Object pool = this.getField((PoolingHttpClientConnectionManager)connectionManager, "pool");
        Assert.assertEquals((Object)new Long(-1L), this.getField(pool, "timeToLive"));
        TimeUnit timeUnit = (TimeUnit)((Object)this.getField(pool, "tunit"));
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)timeUnit));
    }

    @Test
    public void newConnectionManagerWithTTL() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6, 56L, TimeUnit.DAYS, null);
        Assert.assertEquals((long)6L, (long)((PoolingHttpClientConnectionManager)connectionManager).getDefaultMaxPerRoute());
        Assert.assertEquals((long)2L, (long)((PoolingHttpClientConnectionManager)connectionManager).getMaxTotal());
        Object pool = this.getField((PoolingHttpClientConnectionManager)connectionManager, "pool");
        Assert.assertEquals((Object)new Long(56L), this.getField(pool, "timeToLive"));
        TimeUnit timeUnit = (TimeUnit)((Object)this.getField(pool, "tunit"));
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)timeUnit));
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

