/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultOkHttpClientFactoryTest {
    @Test
    public void create() throws Exception {
        DefaultOkHttpClientFactory okHttpClientFactory = new DefaultOkHttpClientFactory();
        DefaultOkHttpClientConnectionPoolFactory poolFactory = new DefaultOkHttpClientConnectionPoolFactory();
        ConnectionPool pool = poolFactory.create(4, 5L, TimeUnit.DAYS);
        OkHttpClient httpClient = okHttpClientFactory.createBuilder(true).connectTimeout(2L, TimeUnit.MILLISECONDS).readTimeout(3L, TimeUnit.HOURS).followRedirects(true).connectionPool(pool).build();
        int connectTimeout = (Integer)this.getField(httpClient, "connectTimeout");
        Assert.assertEquals((long)2L, (long)connectTimeout);
        int readTimeout = (Integer)this.getField(httpClient, "readTimeout");
        Assert.assertEquals((long)TimeUnit.HOURS.toMillis(3L), (long)readTimeout);
        boolean followRedirects = (Boolean)this.getField(httpClient, "followRedirects");
        Assert.assertTrue((boolean)followRedirects);
        ConnectionPool poolFromClient = (ConnectionPool)this.getField(httpClient, "connectionPool");
        Assert.assertEquals((Object)pool, (Object)poolFromClient);
        HostnameVerifier hostnameVerifier = (HostnameVerifier)this.getField(httpClient, "hostnameVerifier");
        Assert.assertTrue((boolean)OkHttpClientFactory.TrustAllHostnames.class.isInstance(hostnameVerifier));
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

