/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import java.net.InetAddress;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;

public class InetUtilsTests {
    @Test
    public void testGetFirstNonLoopbackHostInfo() {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            Assert.assertNotNull((Object)utils.findFirstNonLoopbackHostInfo());
        }
    }

    @Test
    public void testGetFirstNonLoopbackAddress() {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            Assert.assertNotNull((Object)utils.findFirstNonLoopbackAddress());
        }
    }

    @Test
    public void testConvert() throws Exception {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            Assert.assertNotNull((Object)utils.convertAddress(InetAddress.getByName("localhost")));
        }
        Assert.assertNotNull((Object)InetUtils.convert((InetAddress)InetAddress.getByName("localhost")));
    }

    @Test
    public void testHostInfo() throws Exception {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            InetUtils.HostInfo info = utils.findFirstNonLoopbackHostInfo();
            Assert.assertNotNull((Object)info.getIpAddressAsInt());
        }
    }

    @Test
    public void testIgnoreInterface() {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setIgnoredInterfaces(Arrays.asList("docker0", "veth.*"));
        try (InetUtils inetUtils = new InetUtils(properties);){
            Assert.assertTrue((String)"docker0 not ignored", (boolean)inetUtils.ignoreInterface("docker0"));
            Assert.assertTrue((String)"vethAQI2QT0 not ignored", (boolean)inetUtils.ignoreInterface("vethAQI2QT"));
            Assert.assertFalse((String)"docker1 ignored", (boolean)inetUtils.ignoreInterface("docker1"));
        }
    }

    @Test
    public void testDefaultIgnoreInterface() {
        try (InetUtils inetUtils = new InetUtils(new InetUtilsProperties());){
            Assert.assertFalse((String)"docker0 ignored", (boolean)inetUtils.ignoreInterface("docker0"));
        }
    }

    @Test
    public void testSiteLocalAddresses() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setUseOnlySiteLocalInterfaces(true);
        try (InetUtils utils = new InetUtils(properties);){
            Assert.assertFalse((boolean)utils.ignoreAddress(InetAddress.getByName("192.168.0.1")));
            Assert.assertTrue((boolean)utils.ignoreAddress(InetAddress.getByName("5.5.8.1")));
        }
    }

    @Test
    public void testPrefferedNetworksRegex() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setPreferredNetworks(Arrays.asList("192.168.*"));
        try (InetUtils utils = new InetUtils(properties);){
            Assert.assertFalse((boolean)utils.ignoreAddress(InetAddress.getByName("192.168.0.1")));
            Assert.assertTrue((boolean)utils.ignoreAddress(InetAddress.getByName("5.5.8.1")));
        }
    }

    @Test
    public void testPrefferedNetworksSimple() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setPreferredNetworks(Arrays.asList("192"));
        try (InetUtils utils = new InetUtils(properties);){
            Assert.assertFalse((boolean)utils.ignoreAddress(InetAddress.getByName("192.168.0.1")));
            Assert.assertTrue((boolean)utils.ignoreAddress(InetAddress.getByName("5.5.8.1")));
        }
    }
}

