/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.RetryProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public class ConfigServerConfigDataResource
extends ConfigDataResource {
    private final ConfigClientProperties properties;
    private final boolean optional;
    private final Profiles profiles;
    private RetryProperties retryProperties;
    private Log log;
    private boolean isProfileSpecific = false;

    public ConfigServerConfigDataResource(ConfigClientProperties properties, boolean optional, Profiles profiles) {
        this.properties = properties;
        this.optional = optional;
        this.profiles = profiles;
    }

    public ConfigClientProperties getProperties() {
        return this.properties;
    }

    public boolean isProfileSpecific() {
        return this.isProfileSpecific;
    }

    public void setProfileSpecific(boolean profileSpecific) {
        this.isProfileSpecific = profileSpecific;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getProfiles() {
        if (StringUtils.hasText((String)this.properties.getProfile()) && !this.properties.getProfile().equals("default")) {
            return this.properties.getProfile();
        }
        return StringUtils.collectionToCommaDelimitedString(this.getAcceptedProfiles());
    }

    List<String> getAcceptedProfiles() {
        if (this.profiles == null) {
            return Collections.singletonList(!this.properties.getProfile().equals("default") ? this.properties.getProfile() : "default");
        }
        return this.profiles.getAccepted();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public RetryProperties getRetryProperties() {
        return this.retryProperties;
    }

    public void setRetryProperties(RetryProperties retryProperties) {
        this.retryProperties = retryProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigServerConfigDataResource that = (ConfigServerConfigDataResource)((Object)o);
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.optional, that.optional) && Objects.equals(this.profiles, that.profiles);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.optional, this.profiles);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("uris", (Object)this.properties.getUri()).append("optional", this.optional).append("profiles", this.getAcceptedProfiles()).toString();
    }
}

