/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.config.server.config.EncryptionAutoConfiguration;
import org.springframework.cloud.config.server.encryption.SingleTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@Configuration
@AutoConfigureAfter(value={EncryptionAutoConfiguration.class})
public class SingleEncryptorAutoConfiguration {
    @Autowired(required=false)
    private TextEncryptor encryptor;

    @Bean
    @ConditionalOnMissingBean
    public TextEncryptorLocator textEncryptorLocator() {
        return new SingleTextEncryptorLocator(this.encryptor);
    }
}

