/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.config.server.environment.EnvironmentEncryptorEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceController;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
public class ConfigServerMvcConfiguration
implements WebMvcConfigurer {
    @Autowired(required=false)
    private EnvironmentEncryptor environmentEncryptor;
    @Autowired(required=false)
    private ObjectMapper objectMapper = new ObjectMapper();

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("properties", MediaType.valueOf((String)"text/plain"));
        configurer.mediaType("yml", MediaType.valueOf((String)"text/yaml"));
        configurer.mediaType("yaml", MediaType.valueOf((String)"text/yaml"));
    }

    @Bean
    @RefreshScope
    public EnvironmentController environmentController(EnvironmentRepository envRepository, ConfigServerProperties server) {
        EnvironmentController controller = new EnvironmentController(this.encrypted(envRepository, server), this.objectMapper);
        controller.setStripDocumentFromYaml(server.isStripDocumentFromYaml());
        controller.setAcceptEmpty(server.isAcceptEmpty());
        return controller;
    }

    @Bean
    @ConditionalOnBean(value={ResourceRepository.class})
    public ResourceController resourceController(ResourceRepository repository, EnvironmentRepository envRepository, ConfigServerProperties server) {
        ResourceController controller = new ResourceController(repository, this.encrypted(envRepository, server));
        return controller;
    }

    private EnvironmentRepository encrypted(EnvironmentRepository envRepository, ConfigServerProperties server) {
        EnvironmentEncryptorEnvironmentRepository encrypted = new EnvironmentEncryptorEnvironmentRepository(envRepository, this.environmentEncryptor);
        encrypted.setOverrides(server.getOverrides());
        return encrypted;
    }
}

