/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

class YamlS3ConfigFile
extends S3ConfigFile {
    final InputStream inputStream;

    YamlS3ConfigFile(String version, InputStream inputStream) {
        super(version);
        this.inputStream = inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<?, ?> read() {
        YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
        try (InputStream in = this.inputStream;){
            yaml.setResources(new Resource[]{new InputStreamResource(this.inputStream)});
            Properties properties = yaml.getObject();
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load environment", e);
        }
    }
}

