/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.AzureMsiAuthentication;
import org.springframework.vault.authentication.AzureMsiAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.web.client.RestOperations;

public class AzureMsiClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public AzureMsiClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.AZURE_MSI);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        VaultEnvironmentProperties.AzureMsiProperties azureMsi = vaultProperties.getAzureMsi();
        Assert.hasText((String)azureMsi.getRole(), (String)this.missingPropertyForAuthMethod("azure-msi.role", VaultEnvironmentProperties.AuthenticationMethod.AZURE_MSI));
        AzureMsiAuthenticationOptions options = AzureMsiAuthenticationOptions.builder().role(azureMsi.getRole()).build();
        return new AzureMsiAuthentication(options, vaultRestOperations, externalRestOperations);
    }
}

