/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.config.ConfigDataEnvironmentPostProcessor;
import org.springframework.boot.context.config.ConfigDataEnvironmentUpdateListener;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.StandardConfigDataResource;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.FailedToConstructEnvironmentException;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.PassthruEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class NativeEnvironmentRepository
implements EnvironmentRepository,
SearchPathLocator,
Ordered {
    private static final String[] DEFAULT_LOCATIONS = new String[]{"optional:classpath:/", "optional:classpath:/config/", "optional:file:./", "optional:file:./config/"};
    static final Pattern RESOURCE_PATTERN = Pattern.compile("Config resource '(.*?)' via location '(.*)'");
    private static Log logger = LogFactory.getLog(NativeEnvironmentRepository.class);
    private String defaultLabel;
    private String[] searchLocations;
    private boolean failOnError;
    private boolean addLabelLocations;
    private String version;
    private ConfigurableEnvironment environment;
    private int order;

    public NativeEnvironmentRepository(ConfigurableEnvironment environment, NativeEnvironmentProperties properties) {
        this.environment = environment;
        this.addLabelLocations = properties.getAddLabelLocations();
        this.defaultLabel = properties.getDefaultLabel();
        this.failOnError = properties.getFailOnError();
        this.order = properties.getOrder();
        this.setSearchLocations(properties.getSearchLocations());
        this.version = properties.getVersion();
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isAddLabelLocations() {
        return this.addLabelLocations;
    }

    public void setAddLabelLocations(boolean addLabelLocations) {
        this.addLabelLocations = addLabelLocations;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public Environment findOne(String config, String profile, String label) {
        return this.findOne(config, profile, label, false);
    }

    @Override
    public Environment findOne(String config, String profile, String label, boolean includeOrigin) {
        try {
            ConfigurableEnvironment environment = this.getEnvironment(config, profile, label);
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            final HashMap propertySourceToConfigData = new HashMap();
            ConfigDataEnvironmentPostProcessor.applyTo((ConfigurableEnvironment)environment, (ResourceLoader)resourceLoader, null, (Collection)StringUtils.commaDelimitedListToSet((String)profile), (ConfigDataEnvironmentUpdateListener)new ConfigDataEnvironmentUpdateListener(){

                public void onPropertySourceAdded(PropertySource<?> propertySource, ConfigDataLocation location, ConfigDataResource resource) {
                    propertySourceToConfigData.put(propertySource, new PropertySourceConfigData(location, resource));
                }
            });
            environment.getPropertySources().remove("config-data-setup");
            return this.clean(new PassthruEnvironmentRepository(environment).findOne(config, profile, label, includeOrigin), propertySourceToConfigData);
        }
        catch (Exception e) {
            String msg = String.format("Could not construct context for config=%s profile=%s label=%s includeOrigin=%b", config, profile, label, includeOrigin);
            String completeMessage = NestedExceptionUtils.buildMessage((String)msg, (Throwable)NestedExceptionUtils.getMostSpecificCause((Throwable)e));
            throw new FailedToConstructEnvironmentException(completeMessage, e);
        }
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        String[] locations = this.searchLocations;
        if (this.searchLocations == null || this.searchLocations.length == 0) {
            locations = DEFAULT_LOCATIONS;
        }
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        if (label == null) {
            label = this.defaultLabel;
        }
        for (String location : locations) {
            String[] profiles = new String[]{profile};
            if (profile != null) {
                profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            }
            String[] apps = new String[]{application};
            if (application != null) {
                apps = StringUtils.commaDelimitedListToStringArray((String)application);
            }
            for (String prof : profiles) {
                for (String app : apps) {
                    String value = location;
                    if (application != null) {
                        value = value.replace("{application}", app);
                    }
                    if (prof != null) {
                        value = value.replace("{profile}", prof);
                    }
                    if (label != null) {
                        value = value.replace("{label}", label);
                    }
                    if (!value.endsWith("/")) {
                        value = value + "/";
                    }
                    if (!this.isDirectory(value)) continue;
                    output.add(value);
                }
            }
        }
        if (this.addLabelLocations) {
            for (String location : locations) {
                String labelled;
                if (!StringUtils.hasText((String)label) || !this.isDirectory(labelled = location + label.trim() + "/")) continue;
                output.add(labelled);
            }
        }
        return new SearchPathLocator.Locations(application, profile, label, this.version, output.toArray(new String[0]));
    }

    private ConfigurableEnvironment getEnvironment(String application, String profile, String label) {
        StandardEnvironment environment = new StandardEnvironment();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spring.profiles.active", profile);
        String config = application;
        if (!config.equals("application")) {
            config = "application," + config;
        }
        map.put("spring.config.name", config);
        map.put("spring.config.location", StringUtils.arrayToDelimitedString((Object[])this.getLocations(application, profile, label).getLocations(), (String)";"));
        map.put("spring.config.on-not-found", "IGNORE");
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("config-data-setup", map));
        return environment;
    }

    protected Environment clean(Environment env) {
        return this.clean(env, Collections.emptyMap());
    }

    protected Environment clean(Environment env, Map<PropertySource<?>, PropertySourceConfigData> propertySourceToConfigData) {
        Environment result = new Environment(env.getName(), env.getProfiles(), env.getLabel(), this.version, env.getState());
        for (org.springframework.cloud.config.environment.PropertySource source : env.getPropertySources()) {
            boolean matches;
            String originalName;
            String name = originalName = source.getName();
            if (this.environment.getPropertySources().contains(name)) continue;
            String[] locations = null;
            PropertySourceConfigData configData = propertySourceToConfigData.get(source.getOriginalPropertySource());
            if (configData != null && configData.resource instanceof StandardConfigDataResource) {
                StandardConfigDataResource configDataResource = (StandardConfigDataResource)configData.resource;
                name = configDataResource.toString();
                locations = this.configDataLocations(configData.location.split());
            } else {
                Matcher matcher = RESOURCE_PATTERN.matcher(name);
                if (matcher.find()) {
                    name = matcher.group(1);
                    locations = new String[]{matcher.group(2)};
                }
            }
            name = name.replace("\\", "/");
            name = name.replaceAll("\\[(?=\\w:)", "[/");
            name = name.replace("applicationConfig: [", "");
            name = name.replace("file [", "file:");
            name = name.replace("class path resource [", "classpath:/");
            if (name.indexOf(91) < 0) {
                name = name.replace("]", "");
            }
            if (this.searchLocations != null && !(matches = this.matchesLocation(locations, name, result))) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Not adding property source: " + originalName));
                continue;
            }
            logger.info((Object)("Adding property source: " + originalName));
            if (originalName.contains("document #")) {
                result.add(new org.springframework.cloud.config.environment.PropertySource(originalName, source.getSource()));
                continue;
            }
            result.add(new org.springframework.cloud.config.environment.PropertySource(name, source.getSource()));
        }
        return result;
    }

    private String[] configDataLocations(ConfigDataLocation[] locations) {
        String[] stringLocations = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            stringLocations[i] = locations[i].toString();
        }
        return stringLocations;
    }

    private boolean matchesLocation(String[] locations, String name, Environment result) {
        boolean matches = false;
        String normal = name;
        if (normal.startsWith("file:")) {
            normal = StringUtils.cleanPath((String)new File(normal.substring("file:".length())).getAbsolutePath());
        }
        String profile = result.getProfiles() == null ? null : StringUtils.arrayToCommaDelimitedString((Object[])result.getProfiles());
        for (String pattern : this.getLocations(result.getName(), profile, result.getLabel()).getLocations()) {
            if (!pattern.contains(":")) {
                pattern = "file:" + pattern;
            }
            if (pattern.startsWith("optional:")) {
                pattern = pattern.substring("optional:".length());
            }
            if (pattern.startsWith("file:")) {
                pattern = StringUtils.cleanPath((String)new File(pattern.substring("file:".length())).getAbsolutePath()) + "/";
            }
            String finalPattern = pattern;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Testing pattern: " + finalPattern + " with property source: " + name));
            }
            if (normal.startsWith(finalPattern)) {
                matches = true;
                break;
            }
            if (locations != null && (matches = Arrays.stream(locations).map(this::cleanFileLocation).anyMatch(location -> location.startsWith(finalPattern)))) break;
        }
        return matches;
    }

    private String cleanFileLocation(String location) {
        if (location.startsWith("file:")) {
            return StringUtils.cleanPath((String)new File(location.substring("file:".length())).getAbsolutePath()) + "/";
        }
        return location;
    }

    public String[] getSearchLocations() {
        return this.searchLocations;
    }

    public void setSearchLocations(String ... locations) {
        this.searchLocations = locations;
        if (locations != null) {
            for (int i = 0; i < locations.length; ++i) {
                String location = locations[i];
                if (this.isDirectory(location) && !location.endsWith("/")) {
                    location = location + "/";
                }
                locations[i] = location;
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private boolean isDirectory(String location) {
        return !location.contains("{") && !location.endsWith(".properties") && !location.endsWith(".yml") && !location.endsWith(".yaml");
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private final class PropertySourceConfigData {
        private final ConfigDataLocation location;
        private final ConfigDataResource resource;

        private PropertySourceConfigData(ConfigDataLocation location, ConfigDataResource resource) {
            this.location = location;
            this.resource = resource;
        }
    }
}

