/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JsonS3ConfigFile;
import org.springframework.cloud.config.server.environment.PropertyS3ConfigFile;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.environment.YamlS3ConfigFile;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class AwsS3EnvironmentRepository
implements EnvironmentRepository,
Ordered,
SearchPathLocator {
    private static final String AWS_S3_RESOURCE_SCHEME = "s3://";
    private static final String PATH_SEPARATOR = "/";
    private final S3Client s3Client;
    private final String bucketName;
    private final ConfigServerProperties serverProperties;
    protected int order = Integer.MAX_VALUE;

    public AwsS3EnvironmentRepository(S3Client s3Client, String bucketName, ConfigServerProperties server) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.serverProperties = server;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Environment findOne(String specifiedApplication, String specifiedProfiles, String specifiedLabel) {
        String application = !StringUtils.hasText((String)specifiedApplication) ? this.serverProperties.getDefaultApplicationName() : specifiedApplication;
        String profiles = !StringUtils.hasText((String)specifiedProfiles) ? this.serverProperties.getDefaultProfile() : specifiedProfiles;
        String label = !StringUtils.hasText((String)specifiedLabel) ? this.serverProperties.getDefaultLabel() : specifiedLabel;
        String[] profileArray = this.parseProfiles(profiles);
        String[] apps = new String[]{application};
        if (application != null) {
            apps = StringUtils.commaDelimitedListToStringArray((String)application.replace(" ", ""));
        }
        Environment environment = new Environment(application, profileArray);
        environment.setLabel(label);
        for (String profile : profileArray) {
            for (String app : apps) {
                S3ConfigFile s3ConfigFile = this.getS3ConfigFile(app, profile, label);
                if (s3ConfigFile == null) continue;
                environment.setVersion(s3ConfigFile.getVersion());
                Properties config = s3ConfigFile.read();
                config.putAll(this.serverProperties.getOverrides());
                StringBuilder propertySourceName = new StringBuilder().append("s3:").append(app);
                if (profile != null) {
                    propertySourceName.append("-").append(profile);
                }
                environment.add(new PropertySource(propertySourceName.toString(), (Map)config));
            }
        }
        return environment;
    }

    private String[] parseProfiles(String profiles) {
        if (ObjectUtils.isEmpty((Object)profiles)) {
            return new String[]{""};
        }
        List parsedProfiles = Arrays.stream(profiles.split(",")).collect(Collectors.collectingAndThen(Collectors.toList(), p -> {
            p.add("");
            return p;
        }));
        return parsedProfiles.toArray(new String[0]);
    }

    private S3ConfigFile getS3ConfigFile(String application, String profile, String label) {
        String objectKeyPrefix = this.buildObjectKeyPrefix(application, profile, label);
        return this.getS3ConfigFile(objectKeyPrefix);
    }

    private String buildObjectKeyPrefix(String application, String profile, String label) {
        StringBuilder objectKeyPrefix = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)label)) {
            objectKeyPrefix.append(label).append(PATH_SEPARATOR);
        }
        objectKeyPrefix.append(application);
        if (!ObjectUtils.isEmpty((Object)profile)) {
            objectKeyPrefix.append("-").append(profile);
        }
        return objectKeyPrefix.toString();
    }

    private S3ConfigFile getS3ConfigFile(String keyPrefix) {
        try {
            ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".properties");
            return new PropertyS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
        }
        catch (Exception eProperties) {
            try {
                ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".yml");
                return new YamlS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
            }
            catch (Exception eYml) {
                try {
                    ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".yaml");
                    return new YamlS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
                }
                catch (Exception eYaml) {
                    try {
                        ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".json");
                        return new JsonS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
                    }
                    catch (Exception eJson) {
                        return null;
                    }
                }
            }
        }
    }

    private ResponseInputStream<GetObjectResponse> getObject(String key) throws Exception {
        return this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(key).build());
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profiles, String label) {
        StringBuilder baseLocation = new StringBuilder(AWS_S3_RESOURCE_SCHEME + this.bucketName + PATH_SEPARATOR);
        if (!StringUtils.hasText((String)label) && StringUtils.hasText((String)this.serverProperties.getDefaultLabel())) {
            label = this.serverProperties.getDefaultLabel();
        }
        if (StringUtils.hasText((String)label)) {
            baseLocation.append(label);
        }
        return new SearchPathLocator.Locations(application, profiles, label, null, new String[]{baseLocation.toString()});
    }
}

