/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryWrapper;
import org.springframework.core.OrderComparator;

public class CompositeEnvironmentRepository
implements EnvironmentRepository {
    Log log = LogFactory.getLog(this.getClass());
    protected List<EnvironmentRepository> environmentRepositories;
    protected boolean failOnError;

    public CompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories, ObservationRegistry observationRegistry, boolean failOnError) {
        Collections.sort(environmentRepositories, OrderComparator.INSTANCE);
        this.environmentRepositories = observationRegistry.isNoop() ? environmentRepositories : environmentRepositories.stream().map(e -> ObservationEnvironmentRepositoryWrapper.wrap(observationRegistry, e)).collect(Collectors.toList());
        this.failOnError = failOnError;
    }

    public CompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories, boolean failOnError) {
        this(environmentRepositories, ObservationRegistry.NOOP, failOnError);
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        return this.findOne(application, profile, label, false);
    }

    @Override
    public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        Environment env = new Environment(application, new String[]{profile}, label, null, null);
        if (this.environmentRepositories.size() == 1) {
            Environment envRepo = this.environmentRepositories.get(0).findOne(application, profile, label, includeOrigin);
            env.addAll(envRepo.getPropertySources());
            env.setVersion(envRepo.getVersion());
            env.setState(envRepo.getState());
        } else {
            for (EnvironmentRepository repo : this.environmentRepositories) {
                try {
                    env.addAll(repo.findOne(application, profile, label, includeOrigin).getPropertySources());
                }
                catch (Exception e) {
                    if (this.failOnError) {
                        throw e;
                    }
                    this.log.info((Object)("Error adding environment for " + repo));
                }
            }
        }
        return env;
    }
}

