/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import io.micrometer.core.annotation.Timed;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.style.ToStringCreator;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ConfigWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(ConfigWatch.class);
    private final ConsulConfigProperties properties;
    private final ConsulClient consul;
    private final TaskScheduler taskScheduler;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private LinkedHashMap<String, Long> consulIndexes;
    private ApplicationEventPublisher publisher;
    private boolean firstTime = true;
    private ScheduledFuture<?> watchFuture;

    public ConfigWatch(ConsulConfigProperties properties, ConsulClient consul, LinkedHashMap<String, Long> initialIndexes) {
        this(properties, consul, initialIndexes, (TaskScheduler)ConfigWatch.getTaskScheduler());
    }

    public ConfigWatch(ConsulConfigProperties properties, ConsulClient consul, LinkedHashMap<String, Long> initialIndexes, TaskScheduler taskScheduler) {
        this.properties = properties;
        this.consul = consul;
        this.consulIndexes = new LinkedHashMap<String, Long>(initialIndexes);
        this.taskScheduler = taskScheduler;
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::watchConfigKeyValues, (long)this.properties.getWatch().getDelay());
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Timed(value="consul.watch-config-keys")
    public void watchConfigKeyValues() {
        if (this.running.get()) {
            for (String context : this.consulIndexes.keySet()) {
                if (this.properties.getFormat() != ConsulConfigProperties.Format.FILES && !context.endsWith("/")) {
                    context = context + "/";
                }
                try {
                    Response response;
                    Long currentIndex = this.consulIndexes.get(context);
                    if (currentIndex == null) {
                        currentIndex = -1L;
                    }
                    log.trace((Object)("watching consul for context '" + context + "' with index " + currentIndex));
                    String aclToken = this.properties.getAclToken();
                    if (StringUtils.isEmpty((Object)aclToken)) {
                        aclToken = null;
                    }
                    if ((response = this.consul.getKVValues(context, aclToken, new QueryParams((long)this.properties.getWatch().getWaitTime(), currentIndex.longValue()))).getValue() != null && !((List)response.getValue()).isEmpty()) {
                        Long newIndex = response.getConsulIndex();
                        if (newIndex != null && !newIndex.equals(currentIndex)) {
                            if (!this.consulIndexes.containsValue(newIndex) && !currentIndex.equals(-1L)) {
                                log.trace((Object)("Context " + context + " has new index " + newIndex));
                                RefreshEventData data = new RefreshEventData(context, currentIndex, newIndex);
                                this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)data, data.toString()));
                            } else if (log.isTraceEnabled()) {
                                log.trace((Object)("Event for index already published for context " + context));
                            }
                            this.consulIndexes.put(context, newIndex);
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("Same index for context " + context));
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("No value for context " + context));
                }
                catch (Exception e) {
                    if (this.firstTime && this.properties.isFailFast()) {
                        log.error((Object)"Fail fast is set and there was an error reading configuration from consul.");
                        ReflectionUtils.rethrowRuntimeException((Throwable)e);
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Error querying consul Key/Values for context '" + context + "'"), (Throwable)e);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Error querying consul Key/Values for context '" + context + "'. Message: " + e.getMessage()));
                }
            }
        }
        this.firstTime = false;
    }

    public static class RefreshEventData {
        private final String context;
        private final Long prevIndex;
        private final Long newIndex;

        RefreshEventData(String context, Long prevIndex, Long newIndex) {
            this.context = context;
            this.prevIndex = prevIndex;
            this.newIndex = newIndex;
        }

        public String getContext() {
            return this.context;
        }

        public Long getPrevIndex() {
            return this.prevIndex;
        }

        public Long getNewIndex() {
            return this.newIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefreshEventData that = (RefreshEventData)o;
            return Objects.equals(this.context, that.context) && Objects.equals(this.prevIndex, that.prevIndex) && Objects.equals(this.newIndex, that.newIndex);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.prevIndex, this.newIndex);
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("context", (Object)this.context).append("prevIndex", (Object)this.prevIndex).append("newIndex", (Object)this.newIndex).toString();
        }
    }
}

