/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulAutoConfiguration;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnConsulEnabled
public class ConsulConfigBootstrapConfiguration {

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties
    @Import(value={ConsulAutoConfiguration.class})
    @ConditionalOnProperty(name={"spring.cloud.consul.config.enabled"}, matchIfMissing=true)
    protected static class ConsulPropertySourceConfiguration {
        @Autowired
        private ConsulClient consul;

        protected ConsulPropertySourceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ConsulConfigProperties consulConfigProperties(Environment env) {
            ConsulConfigProperties properties = new ConsulConfigProperties();
            if (ObjectUtils.isEmpty((Object)properties.getName())) {
                properties.setName(env.getProperty("spring.application.name", "application"));
            }
            return properties;
        }

        @Bean
        public ConsulPropertySourceLocator consulPropertySourceLocator(ConsulConfigProperties consulConfigProperties) {
            return new ConsulPropertySourceLocator(this.consul, consulConfigProperties);
        }
    }
}

