/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.health.model.Check;
import com.ecwid.consul.v1.health.model.HealthService;
import com.netflix.loadbalancer.Server;
import java.util.Map;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;

public class ConsulServer
extends Server {
    private final Server.MetaInfo metaInfo;
    private final HealthService service;

    public ConsulServer(HealthService healthService) {
        super(ConsulServerUtils.findHost(healthService), healthService.getService().getPort().intValue());
        this.service = healthService;
        this.metaInfo = new Server.MetaInfo(){

            public String getAppName() {
                return ConsulServer.this.service.getService().getService();
            }

            public String getServerGroup() {
                return null;
            }

            public String getServiceIdForDiscovery() {
                return null;
            }

            public String getInstanceId() {
                return ConsulServer.this.service.getService().getId();
            }
        };
        this.setAlive(this.isPassingChecks());
    }

    public Server.MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public HealthService getHealthService() {
        return this.service;
    }

    public Map<String, String> getMetadata() {
        return ConsulServerUtils.getMetadata(this.service);
    }

    public boolean isPassingChecks() {
        for (Check check : this.service.getChecks()) {
            if (check.getStatus() == Check.CheckStatus.PASSING) continue;
            return false;
        }
        return true;
    }
}

