/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={PropertySourceBootstrapProperties.class})
public class PropertySourceBootstrapConfiguration
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    private static Log logger = LogFactory.getLog(PropertySourceBootstrapConfiguration.class);
    private int order = -2147483638;
    @Autowired(required=false)
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();

    public void setPropertySourceLocators(Collection<PropertySourceLocator> propertySourceLocators) {
        this.propertySourceLocators = new ArrayList<PropertySourceLocator>(propertySourceLocators);
    }

    public int getOrder() {
        return this.order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        CompositePropertySource composite = new CompositePropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        boolean empty = true;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            PropertySource<?> source = null;
            source = locator.locate((Environment)environment);
            if (source == null) continue;
            logger.info((Object)("Located property source: " + source));
            composite.addPropertySource(source);
            empty = false;
        }
        if (!empty) {
            MutablePropertySources propertySources = environment.getPropertySources();
            String logConfig = environment.resolvePlaceholders("${logging.config:}");
            if (propertySources.contains(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
                propertySources.remove(BOOTSTRAP_PROPERTY_SOURCE_NAME);
            }
            this.insertPropertySources(propertySources, composite);
            this.reinitializeLoggingSystem(environment, logConfig);
            this.setLogLevels(environment);
        }
    }

    private void reinitializeLoggingSystem(ConfigurableEnvironment environment, String oldLogConfig) {
        String logConfig = environment.resolvePlaceholders("${logging.config:}");
        if (StringUtils.hasText((String)logConfig) && !logConfig.equals(oldLogConfig)) {
            LoggingSystem system = LoggingSystem.get((ClassLoader)LoggingSystem.class.getClassLoader());
            try {
                ResourceUtils.getURL((String)logConfig).openStream().close();
                LogFile logFile = LogFile.get((PropertyResolver)environment);
                system.initialize(logConfig, logFile);
            }
            catch (Exception ex) {
                logger.warn((Object)("Logging config file location '" + logConfig + "' cannot be opened and will be ignored"));
            }
        }
    }

    private void setLogLevels(ConfigurableEnvironment environment) {
        LoggingRebinder rebinder = new LoggingRebinder();
        rebinder.setEnvironment((Environment)environment);
        rebinder.onApplicationEvent(new EnvironmentChangeEvent(Collections.emptySet()));
    }

    private void insertPropertySources(MutablePropertySources propertySources, CompositePropertySource composite) {
        MutablePropertySources incoming = new MutablePropertySources();
        incoming.addFirst((PropertySource)composite);
        PropertySourceBootstrapProperties remoteProperties = new PropertySourceBootstrapProperties();
        new RelaxedDataBinder((Object)remoteProperties, "spring.cloud.config").bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)incoming));
        if (!remoteProperties.isAllowOverride() || !remoteProperties.isOverrideNone() && remoteProperties.isOverrideSystemProperties()) {
            propertySources.addFirst((PropertySource)composite);
            return;
        }
        if (remoteProperties.isOverrideNone()) {
            propertySources.addLast((PropertySource)composite);
            return;
        }
        if (propertySources.contains("systemEnvironment")) {
            if (!remoteProperties.isOverrideSystemProperties()) {
                propertySources.addAfter("systemEnvironment", (PropertySource)composite);
            } else {
                propertySources.addBefore("systemEnvironment", (PropertySource)composite);
            }
        } else {
            propertySources.addLast((PropertySource)composite);
        }
    }
}

