/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.converter.StubGenerator;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class StubGeneratorProvider {
    private final List<StubGenerator> converters = new ArrayList<StubGenerator>();

    public StubGeneratorProvider() {
        this.converters.addAll(SpringFactoriesLoader.loadFactories(StubGenerator.class, null));
    }

    public StubGeneratorProvider(List<StubGenerator> converters) {
        this.converters.addAll(converters);
    }

    @Deprecated
    public Collection<StubGenerator> converterForName(File file) {
        return this.converters.stream().filter(stubGenerator -> stubGenerator.canReadStubMapping(file)).collect(Collectors.toList());
    }

    public Collection<StubGenerator> allOrDefault(StubGenerator defaultStubGenerator) {
        return this.converters.isEmpty() ? Collections.singletonList(defaultStubGenerator) : this.converters;
    }
}

