/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.config.TestMode;

@CacheableTask
class GenerateServerTestsTask
extends DefaultTask {
    static final String TASK_NAME = "generateContractTests";
    private final DirectoryProperty contractsDslDir;
    private final Property<String> nameSuffixForTests;
    private final Property<String> basePackageForTests;
    private final Property<String> baseClassForTests;
    private final Property<String> packageWithBaseClasses;
    private final ListProperty<String> excludedFiles;
    private final ListProperty<String> ignoredFiles;
    private final ListProperty<String> includedFiles;
    private final ListProperty<String> imports;
    private final ListProperty<String> staticImports;
    private final Property<TestMode> testMode;
    private final Property<TestFramework> testFramework;
    private final MapProperty<String, String> baseClassMappings;
    private final Property<Boolean> assertJsonSize;
    private final Property<Boolean> failOnInProgress;
    private final ConfigurableFileCollection classpath;
    private final DirectoryProperty generatedTestSourcesDir;
    private final DirectoryProperty generatedTestResourcesDir;
    final ExecOperations executors;

    @Inject
    public GenerateServerTestsTask(ObjectFactory objects, ExecOperations executors) {
        this.executors = executors;
        this.contractsDslDir = objects.directoryProperty();
        this.nameSuffixForTests = objects.property(String.class);
        this.basePackageForTests = objects.property(String.class);
        this.baseClassForTests = objects.property(String.class);
        this.packageWithBaseClasses = objects.property(String.class);
        this.excludedFiles = objects.listProperty(String.class);
        this.ignoredFiles = objects.listProperty(String.class);
        this.includedFiles = objects.listProperty(String.class);
        this.imports = objects.listProperty(String.class);
        this.staticImports = objects.listProperty(String.class);
        this.testMode = objects.property(TestMode.class);
        this.testFramework = objects.property(TestFramework.class);
        this.baseClassMappings = objects.mapProperty(String.class, String.class);
        this.assertJsonSize = objects.property(Boolean.class);
        this.failOnInProgress = objects.property(Boolean.class);
        this.classpath = objects.fileCollection();
        this.generatedTestSourcesDir = objects.directoryProperty();
        this.generatedTestResourcesDir = objects.directoryProperty();
    }

    @TaskAction
    void generate() {
        File generatedTestSources = ((Directory)this.generatedTestSourcesDir.get()).getAsFile();
        File generatedTestResources = ((Directory)this.generatedTestResourcesDir.get()).getAsFile();
        this.getLogger().info("Generated test sources dir [{}]", (Object)generatedTestSources);
        this.getLogger().info("Generated test resources dir [{}]", (Object)generatedTestResources);
        File contractsDslDir = ((Directory)this.contractsDslDir.get()).getAsFile();
        String includedContracts = ".*";
        this.getLogger().info("Spring Cloud Contract Verifier Plugin: Invoking test sources generation");
        this.getLogger().info("Contracts are unpacked to [{}]", (Object)contractsDslDir);
        this.getLogger().info("Included contracts are [{}]", (Object)includedContracts);
        ContractVerifierConfigProperties properties = this.toConfigProperties(contractsDslDir, includedContracts, generatedTestSources, generatedTestResources);
        ByteArrayOutputStream os = this.getLogger().isDebugEnabled() ? new ByteArrayOutputStream() : NullOutputStream.INSTANCE;
        try {
            String propertiesJson = new ObjectMapper().writeValueAsString((Object)properties);
            this.executors.javaexec(exec -> {
                exec.getMainClass().set((Object)"org.springframework.cloud.contract.verifier.TestGeneratorApplication");
                exec.classpath(new Object[]{this.classpath});
                exec.args(new Object[]{this.quoteAndEscape(propertiesJson)});
                exec.setStandardOutput(os);
                exec.setErrorOutput(os);
            });
        }
        catch (Exception e) {
            throw new GradleException("Spring Cloud Contract Verifier Plugin exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(((Object)os).toString());
            }
        }
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    DirectoryProperty getContractsDslDir() {
        return this.contractsDslDir;
    }

    @Input
    @Optional
    Property<String> getNameSuffixForTests() {
        return this.nameSuffixForTests;
    }

    @Input
    @Optional
    Property<String> getBasePackageForTests() {
        return this.basePackageForTests;
    }

    @Input
    @Optional
    Property<String> getBaseClassForTests() {
        return this.baseClassForTests;
    }

    @Input
    @Optional
    Property<String> getPackageWithBaseClasses() {
        return this.packageWithBaseClasses;
    }

    @Input
    ListProperty<String> getExcludedFiles() {
        return this.excludedFiles;
    }

    @Input
    ListProperty<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    @Input
    ListProperty<String> getIncludedFiles() {
        return this.includedFiles;
    }

    @Input
    ListProperty<String> getImports() {
        return this.imports;
    }

    @Input
    ListProperty<String> getStaticImports() {
        return this.staticImports;
    }

    @Input
    Property<TestMode> getTestMode() {
        return this.testMode;
    }

    @Input
    Property<TestFramework> getTestFramework() {
        return this.testFramework;
    }

    @Input
    MapProperty<String, String> getBaseClassMappings() {
        return this.baseClassMappings;
    }

    @Input
    Property<Boolean> getAssertJsonSize() {
        return this.assertJsonSize;
    }

    @Input
    Property<Boolean> getFailOnInProgress() {
        return this.failOnInProgress;
    }

    @Classpath
    ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputDirectory
    DirectoryProperty getGeneratedTestSourcesDir() {
        return this.generatedTestSourcesDir;
    }

    @OutputDirectory
    DirectoryProperty getGeneratedTestResourcesDir() {
        return this.generatedTestResourcesDir;
    }

    private ContractVerifierConfigProperties toConfigProperties(File contractsDslDir, String includedContracts, File generatedTestSources, File generatedTestResources) {
        List excludedFiles = (List)this.excludedFiles.get();
        List ignoredFiles = (List)this.ignoredFiles.get();
        List includedFiles = (List)this.includedFiles.get();
        String[] imports = ((List)this.imports.get()).toArray(new String[0]);
        String[] staticImports = ((List)this.staticImports.get()).toArray(new String[0]);
        ContractVerifierConfigProperties properties = new ContractVerifierConfigProperties();
        properties.setIncludedContracts(includedContracts);
        properties.setContractsDslDir(contractsDslDir);
        properties.setNameSuffixForTests((String)this.nameSuffixForTests.getOrNull());
        properties.setGeneratedTestSourcesDir(generatedTestSources);
        properties.setGeneratedTestResourcesDir(generatedTestResources);
        properties.setBasePackageForTests((String)this.basePackageForTests.getOrNull());
        properties.setBaseClassForTests((String)this.baseClassForTests.getOrNull());
        properties.setPackageWithBaseClasses((String)this.packageWithBaseClasses.getOrNull());
        properties.setExcludedFiles(excludedFiles);
        properties.setIgnoredFiles(ignoredFiles);
        properties.setIncludedFiles(includedFiles);
        properties.setImports(imports);
        properties.setStaticImports(staticImports);
        properties.setTestMode((TestMode)this.testMode.get());
        properties.setTestFramework((TestFramework)this.testFramework.get());
        properties.setBaseClassMappings((Map)this.baseClassMappings.get());
        properties.setAssertJsonSize((Boolean)this.assertJsonSize.get());
        properties.setFailOnInProgress(((Boolean)this.failOnInProgress.get()).booleanValue());
        return properties;
    }

    private String quoteAndEscape(String str) {
        if (System.getProperty("os.name").contains("Windows")) {
            return "\"" + str.replace("\"", "\\\"") + "\"";
        }
        return str;
    }
}

