/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmTestSuitePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.base.TestingExtension;
import org.gradle.util.GradleVersion;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.ContractsCopyTask;
import org.springframework.cloud.contract.verifier.plugin.GenerateClientStubsFromDslTask;
import org.springframework.cloud.contract.verifier.plugin.GenerateServerTestsTask;
import org.springframework.cloud.contract.verifier.plugin.PublishStubsToScmTask;
import org.springframework.cloud.contract.verifier.plugin.VersionExtractor;

public class SpringCloudContractVerifierGradlePlugin
implements Plugin<Project> {
    private static final Logger logger = Logging.getLogger(SpringCloudContractVerifierGradlePlugin.class);
    private static final String SPRING_CLOUD_VERSION = VersionExtractor.forClass(SpringCloudContractVerifierGradlePlugin.class);
    private static final String GROUP_NAME = "Verification";
    private static final String EXTENSION_NAME = "contracts";
    private static final String CONTRACT_TEST_SOURCE_SET_NAME = "contractTest";
    private static final String CONTRACT_TEST_COMPILE_ONLY_CONFIGURATION_NAME = "contractTestCompileOnly";
    private static final String CONTRACT_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "contractTestImplementation";
    private static final String CONTRACT_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "contractTestRuntimeOnly";
    private static final String CONTRACT_TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "contractTestRuntimeClasspath";
    private static final String CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "contractTestGeneratorRuntimeClasspath";
    private static final String VERIFIER_STUBS_JAR_TASK_NAME = "verifierStubsJar";
    private static final String CONTRACT_TEST_TASK_NAME = "contractTest";
    private Project project;
    private final ProjectLayout layout;
    private final ProviderFactory providers;
    private final ObjectFactory objects;

    @Inject
    public SpringCloudContractVerifierGradlePlugin(ProjectLayout layout, ProviderFactory providers, ObjectFactory objects) {
        this.layout = layout;
        this.providers = providers;
        this.objects = objects;
    }

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(JavaPlugin.class);
        project.getPlugins().apply(JvmTestSuitePlugin.class);
        ContractVerifierExtension extension = (ContractVerifierExtension)project.getExtensions().create(EXTENSION_NAME, ContractVerifierExtension.class, new Object[0]);
        TaskProvider<ContractsCopyTask> copyContracts = this.registerCopyContractsTask(extension);
        TaskProvider<GenerateClientStubsFromDslTask> generateClientStubs = this.registerGenerateClientStubsTask(extension, copyContracts);
        this.registerStubsJarTask(extension, copyContracts, generateClientStubs);
        TaskProvider<GenerateServerTestsTask> generateServerTestsTaskProvider = this.registerGenerateServerTestsTask(extension, copyContracts);
        this.registerPublishStubsToScmTask(extension, generateClientStubs);
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        testing.getSuites().register("contractTest", JvmTestSuite.class, contractTestSuite -> {
            contractTestSuite.useJUnitJupiter();
            contractTestSuite.dependencies(dependencies -> {
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.6")) < 0) {
                    try {
                        Method implementation = dependencies.getClass().getMethod("implementation", Object.class);
                        implementation.invoke(dependencies, project);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException("Unable to add project dependencies", e);
                    }
                } else {
                    dependencies.getImplementation().add((Dependency)dependencies.project());
                }
            });
            contractTestSuite.sources(sourceSet -> {
                this.configureSourceSets(extension, javaExtension, (SourceSet)sourceSet);
                project.getTasks().named(sourceSet.getProcessResourcesTaskName(), processContractTestResourcesTask -> processContractTestResourcesTask.dependsOn(new Object[]{generateServerTestsTaskProvider}));
                project.getTasks().named(sourceSet.getCompileJavaTaskName(), compileContractTestJava -> compileContractTestJava.dependsOn(new Object[]{generateServerTestsTaskProvider}));
                project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> project.getTasks().named(sourceSet.getCompileTaskName("groovy"), compileContractTestGroovy -> compileContractTestGroovy.dependsOn(new Object[]{generateServerTestsTaskProvider})));
                project.getPlugins().withId("kotlin", kotlinPlugin -> project.getTasks().named(sourceSet.getCompileTaskName("kotlin"), compileContractTestKotlin -> compileContractTestKotlin.dependsOn(new Object[]{generateServerTestsTaskProvider})));
                project.getPlugins().withId("org.jetbrains.kotlin.jvm", kotlinJvmPlugin -> project.getTasks().named(sourceSet.getCompileTaskName("kotlin"), compileContractTestKotlin -> compileContractTestKotlin.dependsOn(new Object[]{generateServerTestsTaskProvider})));
            });
            contractTestSuite.getTargets().all(testSuiteTarget -> this.configureTestTask((TaskProvider<Test>)testSuiteTarget.getTestTask()));
        });
        this.configureConfigurations();
        project.getDependencies().add(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME, (Object)("org.springframework.cloud:spring-cloud-contract-converters:" + SPRING_CLOUD_VERSION));
    }

    private SourceSet configureSourceSets(ContractVerifierExtension extension, JavaPluginExtension javaExtension, SourceSet contractTest) {
        SourceSetContainer sourceSets = javaExtension.getSourceSets();
        ConfigurationContainer configurations = this.project.getConfigurations();
        ObjectFactory objects = this.project.getObjects();
        contractTest.getJava().srcDirs(new Object[]{extension.getGeneratedTestJavaSourcesDir()});
        this.project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> {
            GroovySourceDirectorySet groovy = (GroovySourceDirectorySet)contractTest.getExtensions().getByType(GroovySourceDirectorySet.class);
            groovy.srcDirs(new Object[]{extension.getGeneratedTestGroovySourcesDir()});
        });
        contractTest.getResources().srcDirs(new Object[]{extension.getGeneratedTestResourcesDir()});
        SourceSetOutput mainOutput = ((SourceSet)sourceSets.getByName("main")).getOutput();
        SourceSetOutput testOutput = ((SourceSet)sourceSets.getByName("test")).getOutput();
        Configuration contractTestCompileClasspathConfiguration = configurations.getByName(contractTest.getCompileClasspathConfigurationName());
        Configuration contractTestRuntimeClasspathConfiguration = configurations.getByName(contractTest.getRuntimeClasspathConfigurationName());
        contractTest.setCompileClasspath((FileCollection)objects.fileCollection().from(new Object[]{testOutput, mainOutput, contractTestCompileClasspathConfiguration}));
        contractTest.setRuntimeClasspath((FileCollection)objects.fileCollection().from(new Object[]{contractTest.getOutput(), testOutput, mainOutput, contractTestRuntimeClasspathConfiguration}));
        return contractTest;
    }

    private void configureConfigurations() {
        ConfigurationContainer configurations = this.project.getConfigurations();
        Configuration testCompileOnly = configurations.getByName("testCompileOnly");
        Configuration testImplementation = configurations.getByName("testImplementation");
        Configuration testRuntimeOnly = configurations.getByName("testRuntimeOnly");
        Configuration contractTestCompileOnly = configurations.getByName(CONTRACT_TEST_COMPILE_ONLY_CONFIGURATION_NAME);
        Configuration contractTestImplementation = configurations.getByName(CONTRACT_TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration contractTestRuntimeOnly = configurations.getByName(CONTRACT_TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        contractTestCompileOnly.extendsFrom(new Configuration[]{testCompileOnly});
        contractTestImplementation.extendsFrom(new Configuration[]{testImplementation});
        contractTestRuntimeOnly.extendsFrom(new Configuration[]{testRuntimeOnly});
        configurations.create(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME, conf -> {
            conf.setVisible(false);
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
            conf.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, "java-runtime")));
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "library")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objects.named(LibraryElements.class, "jar")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objects.named(Bundling.class, "external")));
            });
            conf.extendsFrom(new Configuration[]{configurations.getByName(CONTRACT_TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
        });
    }

    private void configureTestTask(TaskProvider<Test> contractTestTaskProvider) {
        contractTestTaskProvider.configure(contractTest -> {
            contractTest.setDescription("Runs the contract tests");
            contractTest.setGroup(GROUP_NAME);
            contractTest.shouldRunAfter(new Object[]{this.project.getTasks().named("test")});
        });
        this.project.getTasks().named("check", check -> check.dependsOn(new Object[]{contractTestTaskProvider}));
    }

    private TaskProvider<GenerateServerTestsTask> registerGenerateServerTestsTask(ContractVerifierExtension extension, TaskProvider<ContractsCopyTask> copyContracts) {
        TaskProvider task = this.project.getTasks().register("generateContractTests", GenerateServerTestsTask.class);
        task.configure(generateServerTestsTask -> {
            generateServerTestsTask.setDescription("Generate server tests from the contracts");
            generateServerTestsTask.setGroup(GROUP_NAME);
            generateServerTestsTask.getContractsDslDir().convention(copyContracts.flatMap(ContractsCopyTask::getCopiedContractsFolder));
            generateServerTestsTask.getNameSuffixForTests().convention(extension.getNameSuffixForTests());
            generateServerTestsTask.getBasePackageForTests().convention(extension.getBasePackageForTests());
            generateServerTestsTask.getBaseClassForTests().convention(extension.getBaseClassForTests());
            generateServerTestsTask.getPackageWithBaseClasses().convention(extension.getPackageWithBaseClasses());
            generateServerTestsTask.getExcludedFiles().convention(extension.getExcludedFiles());
            generateServerTestsTask.getIgnoredFiles().convention(extension.getIgnoredFiles());
            generateServerTestsTask.getIncludedFiles().convention(extension.getIncludedFiles());
            generateServerTestsTask.getImports().convention(extension.getImports());
            generateServerTestsTask.getStaticImports().convention(extension.getStaticImports());
            generateServerTestsTask.getTestMode().convention(extension.getTestMode());
            generateServerTestsTask.getTestFramework().convention(extension.getTestFramework());
            generateServerTestsTask.getBaseClassMappings().convention(extension.getBaseClassMappings().getBaseClassMappings());
            generateServerTestsTask.getAssertJsonSize().convention(extension.getAssertJsonSize());
            generateServerTestsTask.getFailOnInProgress().convention(extension.getFailOnInProgress());
            generateServerTestsTask.getClasspath().from(new Object[]{this.project.getConfigurations().getByName(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
            generateServerTestsTask.getGeneratedTestSourcesDir().convention(extension.getTestFramework().flatMap(testFramework -> {
                if (testFramework == TestFramework.SPOCK) {
                    DirectoryProperty correctSourceSetDir = extension.getGeneratedTestGroovySourcesDir();
                    return extension.getGeneratedTestGroovySourcesDir().orElse((Provider)correctSourceSetDir);
                }
                DirectoryProperty correctSourceSetDir = extension.getGeneratedTestJavaSourcesDir();
                return extension.getGeneratedTestJavaSourcesDir().orElse((Provider)correctSourceSetDir);
            }));
            generateServerTestsTask.getGeneratedTestResourcesDir().convention((Provider)extension.getGeneratedTestResourcesDir());
            generateServerTestsTask.dependsOn(new Object[]{copyContracts});
        });
        return task;
    }

    private void registerPublishStubsToScmTask(ContractVerifierExtension extension, TaskProvider<GenerateClientStubsFromDslTask> generateClientStubs) {
        TaskProvider task = this.project.getTasks().register("publishStubsToScm", PublishStubsToScmTask.class);
        task.configure(publishStubsToScmTask -> {
            publishStubsToScmTask.setDescription("The generated stubs get committed to the SCM repo and pushed to origin");
            publishStubsToScmTask.setGroup(GROUP_NAME);
            ContractVerifierExtension.ContractRepository stubs = extension.getPublishStubsToScm().getContractRepository();
            ContractVerifierExtension.ContractRepository original = extension.getContractRepository();
            publishStubsToScmTask.getContractRepository().getRepositoryUrl().convention(stubs.getRepositoryUrl().orElse(original.getRepositoryUrl()));
            publishStubsToScmTask.getContractRepository().getUsername().convention(stubs.getUsername().orElse(original.getUsername()));
            publishStubsToScmTask.getContractRepository().getPassword().convention(stubs.getPassword().orElse(original.getPassword()));
            publishStubsToScmTask.getContractRepository().getProxyHost().convention(stubs.getProxyHost().orElse(original.getProxyHost()));
            publishStubsToScmTask.getContractRepository().getProxyPort().convention(stubs.getProxyPort().orElse(original.getProxyPort()));
            publishStubsToScmTask.getContractsMode().convention(extension.getContractsMode());
            publishStubsToScmTask.getDeleteStubsAfterTest().convention(extension.getDeleteStubsAfterTest());
            publishStubsToScmTask.getFailOnNoContracts().convention(extension.getFailOnNoContracts());
            publishStubsToScmTask.getContractsProperties().convention(extension.getContractsProperties());
            publishStubsToScmTask.getStubsDir().convention((Provider)extension.getStubsOutputDir());
            publishStubsToScmTask.dependsOn(new Object[]{generateClientStubs});
        });
    }

    private TaskProvider<GenerateClientStubsFromDslTask> registerGenerateClientStubsTask(ContractVerifierExtension extension, TaskProvider<ContractsCopyTask> copyContracts) {
        TaskProvider task = this.project.getTasks().register("generateClientStubs", GenerateClientStubsFromDslTask.class, generateClientStubs -> {
            generateClientStubs.setGroup(GROUP_NAME);
            generateClientStubs.setDescription("Generate client stubs from the contracts");
            generateClientStubs.getContractsDslDir().convention(copyContracts.flatMap(ContractsCopyTask::getCopiedContractsFolder));
            generateClientStubs.getExcludedFiles().convention(extension.getExcludedFiles());
            generateClientStubs.getExcludeBuildFolders().convention(extension.getExcludeBuildFolders());
            generateClientStubs.getClasspath().from(new Object[]{this.project.getConfigurations().getByName(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
            generateClientStubs.getStubsOutputDir().convention(extension.getStubsOutputDir().dir(this.buildRootPath("mappings")));
            generateClientStubs.dependsOn(new Object[]{copyContracts});
        });
        return task;
    }

    private void registerStubsJarTask(ContractVerifierExtension extension, TaskProvider<ContractsCopyTask> copyContracts, TaskProvider<GenerateClientStubsFromDslTask> generateClientStubs) {
        TaskProvider verifierStubsJar = this.project.getTasks().register(VERIFIER_STUBS_JAR_TASK_NAME, Jar.class);
        verifierStubsJar.configure(stubsJar -> {
            stubsJar.setDescription("Creates the stubs JAR task");
            stubsJar.setGroup(GROUP_NAME);
            stubsJar.getArchiveBaseName().convention(this.providers.provider(() -> ((Project)this.project).getName()));
            stubsJar.getArchiveClassifier().convention(extension.getStubsSuffix());
            stubsJar.from(new Object[]{extension.getStubsOutputDir()});
            stubsJar.dependsOn(new Object[]{copyContracts});
            stubsJar.dependsOn(new Object[]{generateClientStubs});
        });
        this.project.artifacts(artifactHandler -> artifactHandler.add("archives", (Object)verifierStubsJar));
    }

    private TaskProvider<ContractsCopyTask> registerCopyContractsTask(ContractVerifierExtension extension) {
        TaskProvider task = this.project.getTasks().register("copyContracts", ContractsCopyTask.class, contractsCopyTask -> {
            contractsCopyTask.setGroup(GROUP_NAME);
            contractsCopyTask.setDescription("Copies contracts to the output folder");
            contractsCopyTask.getConvertToYaml().convention(extension.getConvertToYaml());
            contractsCopyTask.getFailOnNoContracts().convention(extension.getFailOnNoContracts());
            contractsCopyTask.getContractsDirectory().convention(extension.getContractsDslDir().flatMap(contractsDslDir -> this.providers.provider(() -> {
                if (contractsDslDir.getAsFile().exists()) {
                    return contractsDslDir;
                }
                Directory legacyContractsDslDir = this.layout.getProjectDirectory().dir("src/test/resources/contracts");
                if (legacyContractsDslDir.getAsFile().exists()) {
                    logger.warn("Spring Cloud Contract Verifier Plugin: Locating contracts in <src/test/resources/contracts> has been removed. Please move them to <src/contractTest/resources/contracts>. This warning message will be removed in a future release.");
                    return contractsDslDir;
                }
                return null;
            })));
            contractsCopyTask.getContractDependency().getGroupId().convention(extension.getContractDependency().getGroupId());
            contractsCopyTask.getContractDependency().getArtifactId().convention(extension.getContractDependency().getArtifactId());
            contractsCopyTask.getContractDependency().getVersion().convention(extension.getContractDependency().getVersion());
            contractsCopyTask.getContractDependency().getClassifier().convention(extension.getContractDependency().getClassifier());
            contractsCopyTask.getContractDependency().getStringNotation().convention(extension.getContractDependency().getStringNotation());
            contractsCopyTask.getContractRepository().getRepositoryUrl().convention(extension.getContractRepository().getRepositoryUrl());
            contractsCopyTask.getContractRepository().getUsername().convention(extension.getContractRepository().getUsername());
            contractsCopyTask.getContractRepository().getPassword().convention(extension.getContractRepository().getPassword());
            contractsCopyTask.getContractRepository().getProxyHost().convention(extension.getContractRepository().getProxyHost());
            contractsCopyTask.getContractRepository().getProxyPort().convention(extension.getContractRepository().getProxyPort());
            contractsCopyTask.getContractsMode().convention(extension.getContractsMode());
            contractsCopyTask.getContractsProperties().convention(extension.getContractsProperties());
            contractsCopyTask.getContractsPath().convention(extension.getContractsPath());
            contractsCopyTask.getExcludeBuildFolders().convention(extension.getExcludeBuildFolders());
            contractsCopyTask.getDeleteStubsAfterTest().convention(extension.getDeleteStubsAfterTest());
            contractsCopyTask.getClasspath().from(new Object[]{this.project.getConfigurations().getByName(CONTRACT_TEST_GENERATOR_RUNTIME_CLASSPATH_CONFIGURATION_NAME)});
            contractsCopyTask.getCopiedContractsFolder().convention(extension.getStubsOutputDir().dir(this.buildRootPath(EXTENSION_NAME)));
            contractsCopyTask.getBackupContractsFolder().convention(extension.getStubsOutputDir().dir(this.buildRootPath("original")));
        });
        return task;
    }

    private Provider<String> buildRootPath(String path) {
        return this.providers.provider(() -> "META-INF" + File.separator + this.project.getGroup() + File.separator + this.project.getName() + File.separator + this.project.getVersion() + File.separator + path);
    }
}

